/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.w3c.dom.Element;

class FileSystemsLoaderUtil
extends XModelObjectLoaderUtil {
    static Map<String, String> oldAttributes = new HashMap<String, String>();

    static {
        oldAttributes.put("application-name", "APPLICATION_NAME");
        oldAttributes.put("workspace-home", "WORKSPACE_HOME");
        oldAttributes.put("info", "INFO");
        oldAttributes.put("location", "LOCATION");
        oldAttributes.put("model-path", "MODEL_PATH");
        oldAttributes.put("root", "ROOT");
        oldAttributes.put("web-root", "root");
        oldAttributes.put("src", "SRC");
    }

    FileSystemsLoaderUtil() {
    }

    boolean isFileSystems(String nodeName) {
        return "FILESYSTEMS".equals(nodeName) || "file-systems".equals(nodeName);
    }

    @Override
    protected Set<String> getAllowedChildren(XModelEntity entity) {
        Set<String> children = super.getAllowedChildren(entity);
        if (this.isFileSystems(entity.getXMLSubPath())) {
            children.add("WEB");
            children.add("web");
        }
        return children;
    }

    @Override
    protected Set<String> getAllowedAttributes(XModelEntity entity) {
        Set<String> attributes = super.getAllowedAttributes(entity);
        if (this.isFileSystems(entity.getXMLSubPath())) {
            attributes.add("WORKSPACE_HOME");
            attributes.add("workspace-home");
        }
        return attributes;
    }

    @Override
    public boolean saveChildren(Element element, XModelObject o) {
        if ("FileSystemJar".equals(o.getModelEntity().getName())) {
            return true;
        }
        boolean b = super.saveChildren(element, o);
        if (b && this.isFileSystems(element.getNodeName())) {
            this.saveWorkspaceHomeAttr(element, o);
            XModelObject w = this.getWeb(o);
            if (w != null) {
                this.save(element, w);
            }
        }
        return b;
    }

    @Override
    public void loadChildren(Element element, XModelObject o) {
        super.loadChildren(element, o);
        if (this.isFileSystems(element.getNodeName())) {
            XModelObject w;
            Element e = XMLUtil.getUniqueChild(element, "web");
            if (e == null) {
                e = XMLUtil.getUniqueChild(element, "WEB");
            }
            if ((w = this.getWeb(o)) != null && e != null) {
                this.load(e, w);
            }
        }
    }

    boolean isModified(XModelObject object) {
        if (object.isModified()) {
            return true;
        }
        XModelObject w = this.getWeb(object);
        return w != null && w.isModified();
    }

    private XModelObject getWeb(XModelObject object) {
        return object.getModel().getByPath("Web");
    }

    private void saveWorkspaceHomeAttr(Element element, XModelObject o) {
        Properties p = o.getModel().getProperties();
        String project = p.getProperty("eclipse.project");
        String workspace = p.getProperty(XModelConstants.WORKSPACE);
        if (project == null) {
            return;
        }
        String relative = workspace.startsWith(String.valueOf(project) + "/") ? "." + workspace.substring(project.length()) : workspace;
        element.setAttribute("workspace-home", relative);
    }

    @Override
    public String getAttribute(Element element, String xmlname, XAttribute attr) {
        if (element == null || xmlname == null) {
            return null;
        }
        if (!element.hasAttribute(xmlname)) {
            String oldAttribute = xmlname;
            while (oldAttribute != null) {
                if ((oldAttribute = oldAttributes.get(oldAttribute)) == null || !element.hasAttribute(oldAttribute)) continue;
                xmlname = oldAttribute;
                break;
            }
        }
        return super.getAttribute(element, xmlname, attr);
    }
}

