/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import org.jboss.tools.common.model.filesystems.impl.LFileObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class LFileObjectImpl
implements LFileObject {
    protected String root;
    protected String aliaspath;
    protected String relpath;
    private File f = null;

    public LFileObjectImpl(String root, String alias, String relpath) {
        this.root = root;
        this.relpath = relpath;
        this.aliaspath = relpath.length() == 0 ? alias : String.valueOf(alias) + '/' + relpath;
        String fn = relpath.length() == 0 ? root : root + '/' + relpath;
        this.f = new File(fn);
    }

    @Override
    public String getName() {
        return this.f == null ? null : this.f.getName();
    }

    @Override
    public boolean exists() {
        return this.f != null && this.f.exists();
    }

    @Override
    public boolean isDirectory() {
        return this.f != null && this.f.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.f != null && this.f.isFile();
    }

    @Override
    public long lastModified() {
        return this.f == null ? 0L : this.f.lastModified();
    }

    @Override
    public String getPath() {
        return this.aliaspath;
    }

    @Override
    public boolean canWrite() {
        return this.f != null && this.f.canWrite();
    }

    @Override
    public String read() {
        return this.f == null ? "" : XModelObjectLoaderUtil.readFile(this.f);
    }

    @Override
    public void write(String s) {
        XModelObjectLoaderUtil.writeFile(this.f, s);
    }

    @Override
    public String[] listFiles() {
        File[] fs;
        File[] fileArray = fs = this.f == null ? null : this.f.listFiles();
        if (fs == null) {
            return new String[0];
        }
        String[] rs = new String[fs.length];
        String rp = this.getPath();
        int i = 0;
        while (i < rs.length) {
            rs[i] = String.valueOf(rp) + '/' + fs[i].getName();
            ++i;
        }
        return rs;
    }

    @Override
    public boolean mkdirs() {
        return this.f != null && this.f.mkdirs();
    }

    @Override
    public boolean delete() {
        if (this.f == null) {
            return true;
        }
        XModelObjectLoaderUtil.remove(this.f);
        return this.f.exists();
    }
}

