/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.loaders.impl;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.common.model.loaders.impl.PropertyValueToken;

class PropertyValueParser {
    static int SKIP_SPACES = 0;
    String value;
    int offset;
    List<PropertyValueToken> tokens;

    public PropertyValueParser(String value) {
        this.value = value;
        this.parse();
    }

    public String getValue() {
        StringBuilder sb = new StringBuilder();
        for (PropertyValueToken t : this.tokens) {
            sb.append(t.value);
        }
        return sb.toString();
    }

    public String getSource() {
        StringBuilder sb = new StringBuilder();
        for (PropertyValueToken t : this.tokens) {
            sb.append(t.source);
        }
        return sb.toString();
    }

    void parse() {
        this.tokens = new ArrayList<PropertyValueToken>();
        this.skipSpaces();
        boolean backSlash = false;
        while (this.offset < this.value.length()) {
            char ch = this.value.charAt(this.offset);
            if (ch == '\\') {
                ++this.offset;
                boolean bl = backSlash = !backSlash;
                if (backSlash) continue;
                this.tokens.add(new PropertyValueToken(this.value.substring(this.offset - 2, this.offset), "\\"));
                continue;
            }
            if (backSlash) {
                backSlash = false;
                if (ch == '\r' || ch == '\n') {
                    this.tokens.add(new PropertyValueToken(this.value.substring(this.offset - 1, this.offset), ""));
                    this.skipSpaces();
                    continue;
                }
                if (ch == 't') {
                    this.tokens.add(new PropertyValueToken(this.value.substring(this.offset - 1, this.offset + 1), "\t"));
                    ++this.offset;
                    continue;
                }
                if (ch == 'f') {
                    this.tokens.add(new PropertyValueToken(this.value.substring(this.offset - 1, this.offset + 1), "\f"));
                    ++this.offset;
                    continue;
                }
                if (ch == 'r') {
                    this.tokens.add(new PropertyValueToken(this.value.substring(this.offset - 1, this.offset + 1), "\r"));
                    ++this.offset;
                    continue;
                }
                if (ch == 'n') {
                    this.tokens.add(new PropertyValueToken(this.value.substring(this.offset - 1, this.offset + 1), "\n"));
                    ++this.offset;
                    continue;
                }
                if (ch == 'u') {
                    int code = 0;
                    int i = ++this.offset;
                    while (i < this.offset + 4) {
                        char ch1 = this.value.charAt(i);
                        int q = 0;
                        if (ch1 >= '0' && ch1 <= '9') {
                            q = ch1 - 48;
                        } else if (ch1 >= 'a' && ch1 <= 'f') {
                            q = 10 + (ch1 - 97);
                        } else if (ch1 >= 'A' && ch1 <= 'F') {
                            q = 10 + (ch1 - 65);
                        }
                        code = code * 16 + q;
                        ++i;
                    }
                    this.tokens.add(new PropertyValueToken(this.value.substring(this.offset - 2, this.offset + 4), "" + (char)code));
                    this.offset += 4;
                    continue;
                }
                this.tokens.add(new PropertyValueToken(this.value.substring(this.offset - 1, this.offset + 1), "" + ch));
                ++this.offset;
                continue;
            }
            this.tokens.add(new PropertyValueToken(this.value.substring(this.offset, this.offset + 1), "" + ch));
            ++this.offset;
        }
        if (backSlash) {
            this.tokens.add(new PropertyValueToken(this.value.substring(this.offset - 1, this.offset), ""));
        }
    }

    void skipSpaces() {
        int off = this.offset;
        while (off < this.value.length() && Character.isWhitespace(this.value.charAt(off))) {
            ++off;
        }
        if (off > this.offset) {
            this.tokens.add(new PropertyValueToken(this.value.substring(this.offset, off), ""));
            this.offset = off;
        }
    }
}

