/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.markers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.markers.XMarker;
import org.jboss.tools.common.model.markers.XMarkerManager;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.PositionHolder;

public class ResourceMarkers {
    public static String TEXT_PROBLEM = "org.jboss.tools.common.model.textproblemmarker";
    public static String CONSTRAINT_PROBLEM = "org.jboss.tools.jst.web.constraintsmarker";
    public static String JST_WEB_PROBLEM = "org.jboss.tools.jst.web.strutsmarker";
    public static String OLD_CONSTRAINT_PROBLEM = "org.jboss.tools.jst.web.ui.constraintsmarker";
    public static String OLD_JST_WEB_PROBLEM = "org.jboss.tools.jst.web.ui.strutsmarker";
    private XModelObject object;
    String type = null;
    String oldType = null;

    public ResourceMarkers(String type) {
        this.type = type;
    }

    public ResourceMarkers(String type, String oldType) {
        this.type = type;
        this.oldType = oldType;
    }

    public void setModelObject(XModelObject object) {
        this.object = object;
    }

    public void update() {
        if (this.object == null || !this.object.isActive()) {
            return;
        }
        this.update0();
    }

    private void update0() {
        Set<XMarker> dms = null;
        HashSet<XMarker> added = null;
        IResource r = EclipseResourceUtil.getResource(this.object);
        if (r == null || !r.exists()) {
            return;
        }
        if (this.object.getParent() instanceof FolderImpl && ((FolderImpl)this.object.getParent()).isOverlapped()) {
            return;
        }
        dms = this.getOwnedMarkers(r);
        String[] errorList = this.getErrors();
        int i = 0;
        while (i < errorList.length) {
            String error = errorList[i];
            if (error != null && error.length() != 0) {
                String attr;
                XMarker marker;
                String message = this.getTrueMessage(error);
                String path = this.getObjectPathForError(i);
                int location = this.getLocation(i);
                if (location < 0) {
                    location = this.getLocation(error);
                }
                if ((marker = this.findMarker(path, message, attr = this.getObjectAttributeForError(i), dms)) != null) {
                    dms.remove(marker);
                } else {
                    marker = new XMarker();
                    if (added == null) {
                        added = new HashSet<XMarker>();
                    }
                    added.add(marker);
                    marker.setType(this.type);
                    marker.setMessage(message);
                    marker.setPath(path);
                    if (attr != null && attr.length() > 0) {
                        marker.setAttribute(attr);
                    }
                }
            }
            ++i;
        }
        if (r instanceof IFile) {
            IFile file = (IFile)r;
            if (dms != null) {
                XMarkerManager.getInstance().clearXMarkers(file, dms);
            }
            if (added != null) {
                XMarkerManager.getInstance().addXMarkers(file, added);
            }
            if (dms != null && !dms.isEmpty() || added != null && !added.isEmpty()) {
                XMarkerManager.getInstance().forceReload(file);
            }
        }
    }

    public static void updateLocation(IMarker marker, int location, int start, int end) throws CoreException {
        if (location >= 0 && marker.getAttribute("lineNumber", -1) != location) {
            marker.setAttribute("lineNumber", location);
        }
        if (start >= 0 && marker.getAttribute("charStart", -1) != start) {
            marker.setAttribute("charStart", start);
        }
        if (end >= 0 && marker.getAttribute("charEnd", -1) != end) {
            marker.setAttribute("charEnd", end);
        }
    }

    private XMarker findMarker(String path, String message, String attr, Set<XMarker> dms) {
        if (dms == null) {
            return null;
        }
        for (XMarker m : dms) {
            if (!message.equals(m.getMessage()) || attr != null && !attr.equals(m.getAttribute()) || this.oldType != null && this.oldType.equals(m.getType())) continue;
            if (!path.equals(m.getPath())) {
                m.setPath(path);
            }
            return m;
        }
        return null;
    }

    protected String getObjectPathForError(int i) {
        return this.object == null ? null : this.object.getPath();
    }

    protected String getObjectAttributeForError(int i) {
        return null;
    }

    protected String getTrueMessage(String message) {
        StringBuffer sb = new StringBuffer();
        int c = 0;
        while (c < message.length()) {
            int i3;
            int i2;
            int i1 = message.indexOf(64, c);
            if (i1 < 0 || (i2 = message.indexOf(64, i1 + 1)) < 0 || (i3 = message.indexOf(64, i2 + 1)) < 0) break;
            if (c > 0) {
                sb.append(message.substring(0, i1));
            }
            sb.append(message.substring(i2 + 1, i3));
            c = i3 + 1;
        }
        sb.append(message.substring(c));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        IResource r = EclipseResourceUtil.getResource(this.object);
        if (!(r instanceof IFile)) {
            return;
        }
        Set<XMarker> ms = this.getOwnedMarkers((IResource)((IFile)r));
        if (ms != null) {
            XMarkerManager xMarkerManager = XMarkerManager.getInstance();
            synchronized (xMarkerManager) {
                Set<XMarker> ms1 = XMarkerManager.getInstance().getMarkers((IFile)r);
                if (ms1 != null) {
                    for (XMarker m : ms) {
                        ms1.remove(m);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<XMarker> getOwnedMarkers(IResource r) {
        if (!(r instanceof IFile)) {
            return null;
        }
        HashSet<XMarker> l = null;
        XMarkerManager xMarkerManager = XMarkerManager.getInstance();
        synchronized (xMarkerManager) {
            Set<XMarker> ms = XMarkerManager.getInstance().getMarkers((IFile)r);
            if (ms != null) {
                for (XMarker m : ms) {
                    if (!this.isOwnedMarker(m)) continue;
                    if (l == null) {
                        l = new HashSet<XMarker>();
                    }
                    l.add(m);
                }
            }
        }
        return l;
    }

    boolean isOwnedMarker(XMarker m) {
        if (m == null) {
            return false;
        }
        String _type = m.getType();
        if (_type == null) {
            return true;
        }
        if (_type.startsWith("org.jboss.tools.")) {
            return _type.equals(this.type) || this.oldType != null && _type.equals(this.oldType);
        }
        return false;
    }

    protected String[] getErrors() {
        return new String[0];
    }

    protected int getLocation(int i) {
        return -1;
    }

    protected int getLocation(String error) {
        return -1;
    }

    protected int getStart(int i) {
        return -1;
    }

    protected int getEnd(int i) {
        return -1;
    }

    public static void refreshProblemMarkersAsync(final XModelObject file) {
        if (!file.isActive()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ResourceMarkers.refreshProblemMarkers(file);
            }
        });
    }

    public static void refreshProblemMarkers(XModelObject file) {
        IResource r = (IResource)file.getAdapter(IResource.class);
        if (r == null) {
            return;
        }
        try {
            IMarker[] ms = r.findMarkers(JST_WEB_PROBLEM, true, 1);
            if (ms != null) {
                int i = 0;
                while (i < ms.length) {
                    String path = ms[i].getAttribute("path", null);
                    if (path != null) {
                        XModelObject o = file.getModel().getByPath(path);
                        if (o == null) {
                            ms[i].delete();
                        } else {
                            String attr = ms[i].getAttribute("attribute", null);
                            PositionHolder h = PositionHolder.getPosition(o, attr);
                            h.update();
                            ResourceMarkers.updateLocation(ms[i], h.getLine(), h.getStart(), h.getEnd());
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }
}

