/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.markers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.markers.XMarker;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class XMarkerManager
implements IResourceChangeListener {
    private static XMarkerManager instance;
    private Map<IFile, Set<XMarker>> xmarkers = new HashMap<IFile, Set<XMarker>>();
    private Map<IFile, Set<XModelObject>> errorObjects = new HashMap<IFile, Set<XModelObject>>();
    private Map<IFile, Set<XModelObject>> warningObjects = new HashMap<IFile, Set<XModelObject>>();
    private Set<IFile> uptodate = new HashSet<IFile>();
    ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
    UpdateJob updateJob = new UpdateJob();

    public static XMarkerManager getInstance() {
        if (instance == null) {
            instance = new XMarkerManager();
        }
        return instance;
    }

    private XMarkerManager() {
        ModelPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if ((event.getType() == 4 || event.getType() == 2) && event.getResource() instanceof IProject) {
            IProject p = (IProject)event.getResource();
            this.clear(p.getFullPath());
            return;
        }
        IResourceDelta delta = event.getDelta();
        try {
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)this.visitor);
            }
        }
        catch (CoreException e) {
            ModelPlugin.getDefault().logError(e);
        }
    }

    private synchronized void clear(IFile f) {
        this.uptodate.remove(f);
        this.errorObjects.remove(f);
        this.warningObjects.remove(f);
    }

    private synchronized void clear(IPath f) {
        Iterator<IFile> it = this.uptodate.iterator();
        while (it.hasNext()) {
            if (!f.isPrefixOf(it.next().getFullPath())) continue;
            it.remove();
        }
        it = this.errorObjects.keySet().iterator();
        while (it.hasNext()) {
            if (!f.isPrefixOf(it.next().getFullPath())) continue;
            it.remove();
        }
        it = this.warningObjects.keySet().iterator();
        while (it.hasNext()) {
            if (!f.isPrefixOf(it.next().getFullPath())) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceReload(IFile file) {
        XMarkerManager xMarkerManager = this;
        synchronized (xMarkerManager) {
            this.uptodate.remove(file);
        }
        this.reload(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(IFile file) {
        Set<XModelObject> os;
        XMarkerManager xMarkerManager = this;
        synchronized (xMarkerManager) {
            if (this.uptodate.contains(file)) {
                return;
            }
            this.uptodate.add(file);
        }
        IMarker[] ms = new IMarker[]{};
        try {
            ms = !file.isAccessible() ? ModelPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.problemmarker", true, 2) : file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        HashSet<XMarker> xms = new HashSet<XMarker>();
        XMarkerManager xMarkerManager2 = this;
        synchronized (xMarkerManager2) {
            Set<XMarker> xms1;
            if (file != null && file.isAccessible() && (xms1 = this.getMarkers(file)) != null) {
                xms.addAll(xms1);
            }
        }
        XMarkerManager xMarkerManager3 = this;
        synchronized (xMarkerManager3) {
            os = this.errorObjects.get(file);
            if (os == null) {
                os = new HashSet<XModelObject>();
                this.errorObjects.put(file, os);
            }
        }
        this.reload(ms, file, xms, os, 2);
        xMarkerManager3 = this;
        synchronized (xMarkerManager3) {
            os = this.warningObjects.get(file);
            if (os == null) {
                os = new HashSet<XModelObject>();
                this.warningObjects.put(file, os);
            }
        }
        xms.clear();
        this.reload(ms, file, xms, os, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reload(IMarker[] ms, IFile file, Set<XMarker> xms, Set<XModelObject> objects, int severity) {
        Object path;
        HashSet<Object> es = new HashSet<Object>();
        int i = 0;
        while (i < ms.length) {
            if (severity == ms[i].getAttribute("severity", 0)) {
                IResource r = ms[i].getResource();
                Object o = EclipseResourceUtil.getObjectByResource(r);
                if (o == null) {
                    o = EclipseResourceUtil.createObjectForResource(r);
                }
                if (o != null) {
                    path = ms[i].getAttribute("path", null);
                    Object object = o = path == null ? o : o.getModel().getByPath((String)path);
                    if (o != null) {
                        es.add(o);
                        String xMarkerManager = ms[i].getAttribute("attribute", null);
                        if (xMarkerManager != null && xMarkerManager.length() > 0) {
                            ((XModelObjectImpl)o).addErrorAttributeDirty(xMarkerManager);
                        }
                    }
                }
            }
            ++i;
        }
        if (!xms.isEmpty()) {
            XModelObject o = EclipseResourceUtil.getObjectByResource((IResource)file);
            if (o == null) {
                o = EclipseResourceUtil.createObjectForResource((IResource)file);
            }
            if (o != null) {
                for (XMarker m : xms) {
                    path = m.getPath();
                    XModelObject xModelObject = o.getModel().getByPath((String)path);
                    if (xModelObject == null) continue;
                    es.add(xModelObject);
                    String attr = m.getAttribute();
                    if (attr == null || attr.length() <= 0) continue;
                    ((XModelObjectImpl)xModelObject).addErrorAttributeDirty(attr);
                }
            }
        }
        HashSet<XModelObject> copy = new HashSet<XModelObject>();
        HashSet<XModelObject> toRemove = new HashSet<XModelObject>();
        HashSet<XModelObject> toAdd = new HashSet<XModelObject>();
        path = this;
        synchronized (path) {
            copy.addAll(objects);
        }
        for (XModelObject xModelObject : copy) {
            if (!es.contains(xModelObject)) {
                if (xModelObject.getErrorState() == severity) {
                    xModelObject.setErrorState(0);
                }
                toRemove.add(xModelObject);
                continue;
            }
            if (!es.contains(xModelObject)) continue;
            if (severity > xModelObject.getErrorState()) {
                xModelObject.setErrorState(severity);
            } else {
                ((XModelObjectImpl)xModelObject).commitErrorAttributes();
            }
            es.remove(xModelObject);
        }
        for (XModelObject xModelObject : es) {
            if (severity > xModelObject.getErrorState()) {
                xModelObject.setErrorState(severity);
            } else {
                ((XModelObjectImpl)xModelObject).commitErrorAttributes();
            }
            if (objects.contains(xModelObject)) continue;
            toAdd.add(xModelObject);
        }
        XMarkerManager xMarkerManager = this;
        synchronized (xMarkerManager) {
            objects.removeAll(toRemove);
            objects.addAll(toAdd);
        }
    }

    void update(XModelObject object) {
        IFile f;
        XModelObject fo = FileSystemsHelper.getFile(object);
        if (fo != null && (f = (IFile)fo.getAdapter(IFile.class)) != null && f.exists()) {
            this.reload(f);
        }
    }

    public int getErrorState(XModelObject object) {
        if (object == null) {
            return 0;
        }
        this.update(object);
        if (object.getErrorState() == 2 || object.getErrorChildCount() > 0) {
            return 2;
        }
        if (object.getErrorState() == 1 || object.getWarningChildCount() > 0) {
            return 1;
        }
        return 0;
    }

    public boolean hasErrors(XModelObject object) {
        this.update(object);
        return object != null && (object.getErrorState() == 2 || object.getErrorChildCount() > 0);
    }

    public boolean hasWarnings(XModelObject object) {
        this.update(object);
        return object != null && (object.getErrorState() == 1 || object.getWarningChildCount() > 0);
    }

    public boolean hasErrors(XModelObject object, String attribute) {
        this.update(object);
        if (attribute == null) {
            return this.hasErrors(object);
        }
        if (object.getErrorState() == 0) {
            return false;
        }
        return object.getAttributeErrorState(attribute);
    }

    public String getError(XModelObject object, String attribute) {
        IFile file;
        XModelObject f = ((XModelObjectImpl)object).getResourceAncestor();
        IFile iFile = file = f == null ? null : (IFile)f.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        IMarker[] ms = null;
        try {
            ms = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException coreException) {
            return null;
        }
        if (ms == null) {
            return null;
        }
        String pathInFile = object.getPath().substring(f.getPath().length());
        int i = 0;
        while (i < ms.length) {
            XModelObject o = object;
            String path = ms[i].getAttribute("path", null);
            if (path == null || path.endsWith(pathInFile)) {
                String attr;
                XModelObject xModelObject = o = path == null ? o : o.getModel().getByPath(path);
                if (o != null && (attr = ms[i].getAttribute("attribute", null)) != null && attr.equals(attribute)) {
                    return ms[i].getAttribute("message", null);
                }
            }
            ++i;
        }
        Set<XMarker> xms = this.getMarkers(file);
        if (xms != null) {
            for (XMarker m : xms) {
                String attr;
                XModelObject o = object;
                String path = m.getPath();
                if (path != null && !path.endsWith(pathInFile)) continue;
                XModelObject xModelObject = o = path == null ? o : o.getModel().getByPath(path);
                if (o == null || (attr = m.getAttribute()) == null || !attr.equals(attribute)) continue;
                return m.getMessage();
            }
        }
        return null;
    }

    Set<XMarker> getMarkers(IFile file) {
        return this.xmarkers.get(file);
    }

    synchronized void clearXMarkers(IFile file, Set<XMarker> removed) {
        Set<XMarker> all = this.getMarkers(file);
        if (all != null) {
            all.removeAll(removed);
        }
    }

    synchronized void addXMarkers(IFile file, Set<XMarker> added) {
        Set<XMarker> all = this.getMarkers(file);
        if (all == null) {
            all = new HashSet<XMarker>();
            this.xmarkers.put(file, all);
        }
        all.addAll(added);
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        ResourceDeltaVisitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource r = delta.getResource();
            if (delta.getKind() == 2) {
                if (r instanceof IFile) {
                    XMarkerManager.this.clear((IFile)r);
                } else {
                    XMarkerManager.this.clear(r.getFullPath());
                }
                return false;
            }
            if (delta.getKind() == 1) {
                return false;
            }
            if (delta.getKind() == 0) {
                return true;
            }
            if (r instanceof IFile) {
                IFile f = (IFile)r;
                if (XMarkerManager.this.uptodate.contains(f)) {
                    ResourceDeltaVisitor resourceDeltaVisitor = this;
                    synchronized (resourceDeltaVisitor) {
                        XMarkerManager.this.uptodate.remove(f);
                    }
                    if (f.exists()) {
                        XMarkerManager.this.updateJob.add(f);
                    }
                }
            }
            return true;
        }
    }

    class UpdateJob
    extends UIJob {
        Set<IFile> fs;
        boolean running;

        UpdateJob() {
            super(Display.getDefault(), "XMarkerManager");
            this.fs = new HashSet<IFile>();
            this.running = false;
        }

        public String getId() {
            return "XMarkerManager";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            UpdateJob updateJob = this;
            synchronized (updateJob) {
                this.running = true;
            }
            try {
                IFile f = null;
                while ((f = this.nextFile()) != null) {
                    XMarkerManager.this.reload(f);
                }
            }
            catch (Throwable throwable) {
                UpdateJob updateJob2 = this;
                synchronized (updateJob2) {
                    this.running = false;
                }
                throw throwable;
            }
            UpdateJob updateJob3 = this;
            synchronized (updateJob3) {
                this.running = false;
            }
            return Status.OK_STATUS;
        }

        synchronized IFile nextFile() {
            if (this.fs.isEmpty()) {
                return null;
            }
            IFile f = this.fs.iterator().next();
            this.fs.remove(f);
            return f;
        }

        public synchronized void add(IFile f) {
            if (this.fs.contains(f)) {
                return;
            }
            this.fs.add(f);
            if (!this.running) {
                this.running = true;
                this.schedule(100L);
            }
        }
    }
}

