/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.jboss.tools.common.log.BaseUIPlugin;
import org.jboss.tools.common.log.IPluginLog;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.plugin.IModelPlugin;
import org.jboss.tools.common.model.plugin.XModelSaveParticipant;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ModelPlugin
extends BaseUIPlugin
implements IModelPlugin,
IWindowListener {
    public static final String PLUGIN_ID = "org.jboss.tools.common.model";
    private static ModelPlugin plugin;
    private ResourceBundle resourceBundle;
    private XModelSaveParticipant save = new XModelSaveParticipant();
    public static final String TEMP_FILE_PREFIX = "efs_";
    File tempFolder;
    File stateTempFolder;

    public ModelPlugin() {
        plugin = this;
        try {
            File f = File.createTempFile(TEMP_FILE_PREFIX, ".x");
            this.tempFolder = f.getParentFile();
            f.deleteOnExit();
        }
        catch (IOException e) {
            ModelPlugin.getPluginLog().logError("ModelPlugin:requestForTempFolder:" + e.getMessage());
        }
    }

    public static ModelPlugin getDefault() {
        return plugin;
    }

    public File getTempFolder() {
        return this.tempFolder;
    }

    public File getStateTempFolder() {
        return this.stateTempFolder;
    }

    public static boolean isDebugEnabled() {
        return ModelPlugin.getDefault().isDebugging();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = ModelPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public XModelSaveParticipant getSaveParticipant() {
        return this.save;
    }

    public void start(BundleContext context) throws Exception {
        System.setProperty(XModelConstants.HOME, EclipseResourceUtil.getInstallPath(context.getBundle()));
        super.start(context);
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        File location = Platform.getStateLocation((Bundle)bundle).toFile();
        this.stateTempFolder = new File(location, "tmp");
        this.stateTempFolder.mkdirs();
    }

    protected void initializeDefaultPluginPreferences() {
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.cleanTempFiles();
        XJob.shutdown();
    }

    private void cleanTempFiles() {
        this.cleanEFS_Files(this.tempFolder, System.currentTimeMillis() - 2592000000L);
        this.cleanEFS_Files(this.stateTempFolder, -1L);
    }

    private void cleanEFS_Files(File folder, long beforeTime) {
        File[] fs;
        if (folder != null && folder.exists() && (fs = folder.listFiles()) != null) {
            int i = 0;
            while (i < fs.length) {
                String n = fs[i].getName();
                if (n.startsWith(TEMP_FILE_PREFIX) && (beforeTime == -1L || fs[i].lastModified() < beforeTime)) {
                    fs[i].delete();
                }
                ++i;
            }
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        try {
            this.save.saving(null);
        }
        catch (CoreException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public static IPluginLog getPluginLog() {
        return ModelPlugin.getDefault();
    }

    public static boolean isUTF8BOM(String encoding, IFile file) throws CoreException {
        byte[] bom;
        IContentDescription description;
        if ("UTF-8".equals(encoding) && file != null && file.exists() && (description = file.getContentDescription()) != null && (bom = (byte[])description.getProperty(IContentDescription.BYTE_ORDER_MARK)) != null) {
            if (bom != IContentDescription.BOM_UTF_8) {
                throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 0, "wrongByteOrderMark", null));
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContent(InputStream contentStream, String encoding, boolean skipUTF8BOM) throws CoreException {
        String string;
        Reader in = null;
        try {
            if (skipUTF8BOM) {
                int i = 0;
                while (i < 3) {
                    if (contentStream.read() == -1) {
                        throw new IOException("notEnoughBytesForBOM");
                    }
                    ++i;
                }
            }
            in = encoding == null ? new BufferedReader(new InputStreamReader(contentStream), 15360) : new BufferedReader(new InputStreamReader(contentStream, encoding), 15360);
            StringBuffer buffer = new StringBuffer(15360);
            char[] readBuffer = new char[2048];
            int n = in.read(readBuffer);
            while (true) {
                if (n <= 0) {
                    string = buffer.toString();
                    break;
                }
                buffer.append(readBuffer, 0, n);
                n = in.read(readBuffer);
            }
        }
        catch (IOException x) {
            try {
                throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 0, "Failed to access or read underlying storage", (Throwable)x));
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                        throw throwable;
                    }
                    contentStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            if (in != null) {
                in.close();
                return string;
            }
            contentStream.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }
}

