/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.PositionSearcher;

public class RenameModelObjectChange
extends TextFileChange {
    boolean ok = false;
    private String newName;
    List<ObjectSet> list = new ArrayList<ObjectSet>();

    public static RenameModelObjectChange createChange(XModelObject[] objects, String newName, String attributeName) {
        if (objects == null || objects.length == 0) {
            return null;
        }
        String name = objects[0].getPresentationString();
        IFile f = RenameModelObjectChange.getFile(objects[0]);
        if (f == null) {
            return null;
        }
        return new RenameModelObjectChange(name, f, objects, newName, attributeName);
    }

    public static RenameModelObjectChange createChange(XModelObject fileObject, String newName) {
        String name = fileObject.getPresentationString();
        IFile f = RenameModelObjectChange.getFile(fileObject);
        if (f == null) {
            return null;
        }
        return new RenameModelObjectChange(name, f, newName);
    }

    private RenameModelObjectChange(String name, IFile file, String newName) {
        super(name, file);
        this.newName = newName;
    }

    private RenameModelObjectChange(String name, IFile file, XModelObject[] objects, String newName, String attributeName) {
        this(name, file, newName);
        this.addEdits(objects, attributeName, "Update field reference");
    }

    public void addEdits(XModelObject[] objects, String attributeName, String textEditName) {
        this.list.add(new ObjectSet(objects, attributeName));
        PositionSearcher searcher = new PositionSearcher();
        XModelObject o = ((XModelObjectImpl)objects[0]).getResourceAncestor();
        String text = ((FileAnyImpl)o).getAsText();
        int i = 0;
        while (i < objects.length) {
            searcher.init(text, objects[i], attributeName);
            searcher.execute();
            int bp = searcher.getStartPosition();
            int ep = searcher.getEndPosition();
            this.ok = false;
            if (bp >= 0 && ep >= ep) {
                ReplaceEdit edit = new ReplaceEdit(bp, ep - bp, this.newName);
                TextChangeCompatibility.addTextEdit((TextChange)this, (String)textEditName, (TextEdit)edit);
                this.ok = true;
            }
            ++i;
        }
    }

    protected static IFile getFile(XModelObject object) {
        XModelObject o = ((XModelObjectImpl)object).getResourceAncestor();
        return o == null ? null : (IFile)EclipseResourceUtil.getResource(o);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Change result = null;
        if (this.ok) {
            result = super.perform(pm);
        } else {
            for (ObjectSet set : this.list) {
                int i = 0;
                while (i < set.objects.length) {
                    set.objects[i].getModel().changeObjectAttribute(set.objects[i], set.attributeName, this.newName);
                    ++i;
                }
            }
        }
        return result;
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return MessageFormat.format("Edit {0}", this.list.get((int)0).attributeName);
    }

    class ObjectSet {
        XModelObject[] objects;
        String attributeName;

        ObjectSet(XModelObject[] objects, String attributeName) {
            this.objects = objects;
            this.attributeName = attributeName;
        }
    }
}

