/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.search.impl;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class SearchDefaultHandler
extends AbstractHandler {
    static String CONSTRAINT_ENTITY = "SearchValue";
    static SpecialWizard wizard = null;

    static SpecialWizard wizard() {
        return wizard;
    }

    @Override
    public boolean isEnabled(XModelObject object) {
        return SearchDefaultHandler.wizard() != null && object != null || object.getPath() != null;
    }

    @Override
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        this.executeHandler(object, new XModelObject[]{object}, p);
    }

    @Override
    public void executeHandler(XModelObject object, XModelObject[] objects, Properties p) throws XModelException {
        if (!this.isEnabled(object) || objects == null || objects.length == 0) {
            return;
        }
        XModelObject sc = this.getModifiedSearch(object, objects);
        if (sc == null) {
            return;
        }
        wizard.setObject(new Object[]{sc});
        wizard.execute();
    }

    private XModelObject getModifiedSearch(XModelObject object, XModelObject[] objects) throws XModelException {
        XModel model = object.getModel();
        XModelObject sc = this.findOrCreateDefaultSearch(object, objects);
        ServiceDialog d = model.getService();
        XEntityData ed = this.getSearchEntityData(sc);
        int i = d.showDialog("Search", this.getDialogTitle(objects), new String[]{ModelMessages.OK, ModelMessages.Cancel}, ed, 0);
        if (i != 0) {
            return null;
        }
        Properties p = DefaultCreateHandler.extractProperties(ed);
        Enumeration<Object> en = p.keys();
        XModelObject vc = sc.getChildByPath("Match/value constraint");
        while (en.hasMoreElements()) {
            String n = (String)en.nextElement();
            String v = p.getProperty(n);
            model.changeObjectAttribute(vc, n, v);
        }
        model.saveOptions();
        return sc;
    }

    private XModelObject findOrCreateDefaultSearch(XModelObject object, XModelObject[] objects) throws XModelException {
        XModel model = object.getModel();
        XModelObject sr = model.getByPath("XStudio/Search");
        XModelObject ds = sr.getChildByPath("Default");
        Properties p = new Properties();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < objects.length) {
            if (i > 0) {
                sb.append(";");
            }
            sb.append(objects[i].getPath());
            ++i;
        }
        if (ds == null) {
            p.setProperty("name", "Default");
            p.setProperty("root", sb.toString());
            ds = XModelObjectLoaderUtil.createValidObject(model, "SearchCommand", p);
            sr.addChild(ds);
            sr.setModified(true);
        } else {
            model.changeObjectAttribute(ds, "root", sb.toString());
        }
        XModelObject match = ds.getChildByPath("Match");
        XModelObject v = null;
        if (match.getChildren(CONSTRAINT_ENTITY).length > 0) {
            v = match.getChildren(CONSTRAINT_ENTITY)[0];
        } else {
            p.clear();
            p.setProperty("name", "value constraint");
            v = XModelObjectLoaderUtil.createValidObject(model, CONSTRAINT_ENTITY, p);
            match.addChild(v);
            match.setModified(true);
        }
        return ds;
    }

    private String getDialogTitle(XModelObject[] os) {
        if (os.length == 1) {
            return MessageFormat.format("Find in path {0}", os[0].getPath());
        }
        StringBuffer sb = new StringBuffer("Find in paths:");
        int i = 0;
        while (i < os.length) {
            sb.append("\n").append(os[i].getPath());
            ++i;
        }
        return sb.toString();
    }

    private XEntityData getSearchEntityData(XModelObject sc) {
        XModelObject c = sc.getChildByPath("Match/value constraint");
        String[][] ds = new String[][]{{"SearchValue", "yes"}, {"text to find", "yes"}, {"property name", "no"}, {"ignore case", "no"}};
        XEntityDataImpl d = XEntityDataImpl.create(ds);
        XAttributeData[] as = d.getAttributeData();
        int i = 0;
        while (i < as.length) {
            String n = as[i].getAttribute().getName();
            String v = c.getAttributeValue(n);
            if (v != null) {
                as[i].setValue(v);
            }
            ++i;
        }
        return d;
    }
}

