/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.undo;

import java.text.MessageFormat;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.icons.impl.XModelObjectIcon;
import org.jboss.tools.common.model.undo.XUndoableImpl;

public class XRemoveUndo
extends XUndoableImpl {
    protected XModel model = null;
    protected String parentpath = null;
    protected String childpath = null;
    protected XModelObject child = null;

    public XRemoveUndo(XModelObject parent, XModelObject child) {
        this.model = parent.getModel();
        this.parentpath = parent.getPath();
        this.childpath = child.getPathPart();
        this.child = child.copy(false);
        this.description = MessageFormat.format("{0} {1} in {2} {3}", child.getAttributeValue("element type"), child.getModelEntity().getRenderer().getTitle(child), parent.getAttributeValue("element type"), parent.getModelEntity().getRenderer().getTitle(parent));
        String[] types = child.getModelEntity().getRenderer().getIconNames();
        String iconType = types.length == 0 ? "main" : child.getModelEntity().getRenderer().getIconNames()[0];
        this.icon = new XModelObjectIcon(child).getEclipseImage0(new String[]{iconType});
        this.kind = 2;
    }

    @Override
    public void doUndo() {
        XModelObject parent = this.model.getByPath(this.parentpath);
        if (this.child != null) {
            parent.addChild(this.child);
            this.child.setModified(true);
        }
    }

    @Override
    public void doRedo() {
        XModelObject parent = this.model.getByPath(this.parentpath);
        if (parent == null) {
            return;
        }
        XModelObject c = parent.getChildByPath(this.childpath);
        if (c != null) {
            parent.removeChild(c);
            parent.setModified(true);
            this.child = c.copy(false);
        }
    }
}

