/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.osgi.framework.Bundle;

public class ModelFeatureFactory {
    public static final String POINT = "org.jboss.tools.common.model.classes";
    private Map<String, IConfigurationElement> elements = new HashMap<String, IConfigurationElement>();
    private Set<String> instanceFailures = new HashSet<String>();
    private Set<String> classFailures = new HashSet<String>();

    public static ModelFeatureFactory getInstance() {
        return ModelFeatureFactoryHolder.INSTANCE;
    }

    private ModelFeatureFactory() {
        this.init();
    }

    private void init() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(POINT);
        IExtension[] es = point.getExtensions();
        int i = 0;
        while (i < es.length) {
            IConfigurationElement[] cs = es[i].getConfigurationElements();
            int j = 0;
            while (j < cs.length) {
                String id = cs[j].getAttribute("id");
                this.elements.put(id, cs[j]);
                ++j;
            }
            ++i;
        }
    }

    private boolean isActive() {
        int state;
        Bundle b = Platform.getBundle((String)"org.jboss.tools.common.model");
        int n = state = b == null ? -1 : b.getState();
        return state == 32;
    }

    public Object createFeatureInstance(String id) {
        if (this.instanceFailures.contains(id)) {
            return null;
        }
        IConfigurationElement c = this.elements.get(id);
        if (c == null) {
            this.instanceFailures.add(id);
            this.classFailures.add(id);
            ModelPlugin.getPluginLog().logError((Throwable)new Exception("Model feature " + id + " is not registered with extension point " + POINT));
            return null;
        }
        try {
            return c.createExecutableExtension("class");
        }
        catch (CoreException e) {
            this.instanceFailures.add(id);
            ModelPlugin.getPluginLog().logError("Cannot create model feature instance " + id + ".", (Throwable)e);
        }
        catch (InvalidRegistryObjectException e) {
            this.instanceFailures.add(id);
            ModelPlugin.getPluginLog().logError("Cannot create model feature instance " + id + ".", (Throwable)e);
        }
        return null;
    }

    public Class getFeatureClass(String id) {
        if (this.classFailures.contains(id)) {
            return null;
        }
        IConfigurationElement c = this.elements.get(id);
        if (c == null) {
            this.classFailures.add(id);
            this.instanceFailures.add(id);
            ModelPlugin.getPluginLog().logError((Throwable)new Exception("Model feature " + id + " is not registered with extension point " + POINT));
            return null;
        }
        try {
            String n = c.getNamespaceIdentifier();
            Bundle b = Platform.getBundle((String)n);
            String cls = c.getAttribute("class");
            return b.loadClass(cls);
        }
        catch (ClassNotFoundException e) {
            this.classFailures.add(id);
            if (!this.isActive()) {
                return null;
            }
            ModelPlugin.getPluginLog().logError("Cannot create model feature class " + c.getAttribute("class") + ".", (Throwable)e);
            return null;
        }
    }

    public XModelObject createXModelObjectInstance(String id) {
        Object o = this.createFeatureInstance(id);
        if (o == null) {
            return null;
        }
        try {
            return (XModelObject)o;
        }
        catch (ClassCastException e) {
            this.instanceFailures.add(id);
            ModelPlugin.getPluginLog().logError("Model feature " + id + " is not instance of XModelObject", (Throwable)e);
            return null;
        }
    }

    /* synthetic */ ModelFeatureFactory(ModelFeatureFactory modelFeatureFactory) {
        this();
    }

    public static class ModelFeatureFactoryHolder {
        public static final ModelFeatureFactory INSTANCE = new ModelFeatureFactory(null);
    }
}

