/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.util.extension;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.model.XModelException;

public class ExtensionPointUtil {
    public static Object findClassByElementId(String pointId, String id) throws CoreException {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(pointId);
        return ExtensionPointUtil.findClassByElementId(point, id);
    }

    public static Object findClassByElementId(IExtensionPoint point, String id) throws CoreException {
        IConfigurationElement element = ExtensionPointUtil.getElementById(point, id);
        if (element == null) {
            throw new XModelException(MessageFormat.format("Configuration element with id={0} is not found", id));
        }
        String className = element.getAttribute("class");
        if (className == null || className.length() == 0) {
            throw new XModelException(MessageFormat.format("Configuration element with id={0} does not define ''class'' attribute", id));
        }
        return element.createExecutableExtension("class");
    }

    private static IConfigurationElement getElementById(IExtensionPoint point, String id) {
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement element = ExtensionPointUtil.getElementById(extensions[i].getConfigurationElements(), id);
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private static IConfigurationElement getElementById(IConfigurationElement[] elements, String id) {
        int i = 0;
        while (i < elements.length) {
            if (id.equals(elements[i].getAttribute("id"))) {
                return elements[i];
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            IConfigurationElement element = ExtensionPointUtil.getElementById(elements[i].getChildren(), id);
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }
}

