/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ActionConfigMatcher;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.DataSourceConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;

public class ModuleConfigImpl
implements Serializable,
ModuleConfig {
    protected HashMap actionConfigs = null;
    protected List actionConfigList = null;
    protected HashMap dataSources = null;
    protected HashMap exceptions = null;
    protected HashMap formBeans = null;
    protected HashMap forwards = null;
    protected HashMap messageResources = null;
    protected ArrayList plugIns = null;
    protected boolean configured = false;
    protected ControllerConfig controllerConfig = null;
    protected String prefix = null;
    protected String actionFormBeanClass = "org.apache.struts.action.ActionFormBean";
    protected String actionMappingClass = "org.apache.struts.action.ActionMapping";
    protected String actionForwardClass = "org.apache.struts.action.ActionForward";
    protected ActionConfigMatcher matcher = null;

    public ModuleConfigImpl(String prefix) {
        this.prefix = prefix;
        this.actionConfigs = new HashMap();
        this.actionConfigList = new ArrayList();
        this.actionFormBeanClass = "org.apache.struts.action.ActionFormBean";
        this.actionMappingClass = "org.apache.struts.action.ActionMapping";
        this.actionForwardClass = "org.apache.struts.action.ActionForward";
        this.configured = false;
        this.controllerConfig = null;
        this.dataSources = new HashMap();
        this.exceptions = new HashMap();
        this.formBeans = new HashMap();
        this.forwards = new HashMap();
        this.messageResources = new HashMap();
        this.plugIns = new ArrayList();
    }

    public boolean getConfigured() {
        return this.configured;
    }

    public ControllerConfig getControllerConfig() {
        if (this.controllerConfig == null) {
            this.controllerConfig = new ControllerConfig();
        }
        return this.controllerConfig;
    }

    public void setControllerConfig(ControllerConfig cc) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.controllerConfig = cc;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.prefix = prefix;
    }

    public String getActionFormBeanClass() {
        return this.actionFormBeanClass;
    }

    public void setActionFormBeanClass(String actionFormBeanClass) {
        this.actionFormBeanClass = actionFormBeanClass;
    }

    public String getActionMappingClass() {
        return this.actionMappingClass;
    }

    public void setActionMappingClass(String actionMappingClass) {
        this.actionMappingClass = actionMappingClass;
    }

    public void addActionConfig(ActionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        config.setModuleConfig(this);
        this.actionConfigs.put(config.getPath(), config);
        this.actionConfigList.add(config);
    }

    public void addDataSourceConfig(DataSourceConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.dataSources.put(config.getKey(), config);
    }

    public void addExceptionConfig(ExceptionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.exceptions.put(config.getType(), config);
    }

    public void addFormBeanConfig(FormBeanConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.formBeans.put(config.getName(), config);
    }

    public String getActionForwardClass() {
        return this.actionForwardClass;
    }

    public void setActionForwardClass(String actionForwardClass) {
        this.actionForwardClass = actionForwardClass;
    }

    public void addForwardConfig(ForwardConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.forwards.put(config.getName(), config);
    }

    public void addMessageResourcesConfig(MessageResourcesConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.messageResources.put(config.getKey(), config);
    }

    public void addPlugInConfig(PlugInConfig plugInConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.plugIns.add(plugInConfig);
    }

    public ActionConfig findActionConfig(String path) {
        ActionConfig config = (ActionConfig)this.actionConfigs.get(path);
        if (config == null) {
            config = this.matcher.match(path);
        }
        return config;
    }

    public ActionConfig[] findActionConfigs() {
        ActionConfig[] results = new ActionConfig[this.actionConfigList.size()];
        return this.actionConfigList.toArray(results);
    }

    public DataSourceConfig findDataSourceConfig(String key) {
        return (DataSourceConfig)this.dataSources.get(key);
    }

    public DataSourceConfig[] findDataSourceConfigs() {
        DataSourceConfig[] results = new DataSourceConfig[this.dataSources.size()];
        return this.dataSources.values().toArray(results);
    }

    public ExceptionConfig findExceptionConfig(String type) {
        return (ExceptionConfig)this.exceptions.get(type);
    }

    public ExceptionConfig[] findExceptionConfigs() {
        ExceptionConfig[] results = new ExceptionConfig[this.exceptions.size()];
        return this.exceptions.values().toArray(results);
    }

    public FormBeanConfig findFormBeanConfig(String name) {
        return (FormBeanConfig)this.formBeans.get(name);
    }

    public FormBeanConfig[] findFormBeanConfigs() {
        FormBeanConfig[] results = new FormBeanConfig[this.formBeans.size()];
        return this.formBeans.values().toArray(results);
    }

    public ForwardConfig findForwardConfig(String name) {
        return (ForwardConfig)this.forwards.get(name);
    }

    public ForwardConfig[] findForwardConfigs() {
        ForwardConfig[] results = new ForwardConfig[this.forwards.size()];
        return this.forwards.values().toArray(results);
    }

    public MessageResourcesConfig findMessageResourcesConfig(String key) {
        return (MessageResourcesConfig)this.messageResources.get(key);
    }

    public MessageResourcesConfig[] findMessageResourcesConfigs() {
        MessageResourcesConfig[] results = new MessageResourcesConfig[this.messageResources.size()];
        return this.messageResources.values().toArray(results);
    }

    public PlugInConfig[] findPlugInConfigs() {
        PlugInConfig[] results = new PlugInConfig[this.plugIns.size()];
        return this.plugIns.toArray(results);
    }

    public void freeze() {
        this.configured = true;
        ActionConfig[] aconfigs = this.findActionConfigs();
        int i = 0;
        while (i < aconfigs.length) {
            aconfigs[i].freeze();
            ++i;
        }
        this.matcher = new ActionConfigMatcher(aconfigs);
        this.getControllerConfig().freeze();
        DataSourceConfig[] dsconfigs = this.findDataSourceConfigs();
        int i2 = 0;
        while (i2 < dsconfigs.length) {
            dsconfigs[i2].freeze();
            ++i2;
        }
        ExceptionConfig[] econfigs = this.findExceptionConfigs();
        int i3 = 0;
        while (i3 < econfigs.length) {
            econfigs[i3].freeze();
            ++i3;
        }
        FormBeanConfig[] fbconfigs = this.findFormBeanConfigs();
        int i4 = 0;
        while (i4 < fbconfigs.length) {
            fbconfigs[i4].freeze();
            ++i4;
        }
        ForwardConfig[] fconfigs = this.findForwardConfigs();
        int i5 = 0;
        while (i5 < fconfigs.length) {
            fconfigs[i5].freeze();
            ++i5;
        }
        MessageResourcesConfig[] mrconfigs = this.findMessageResourcesConfigs();
        int i6 = 0;
        while (i6 < mrconfigs.length) {
            mrconfigs[i6].freeze();
            ++i6;
        }
        PlugInConfig[] piconfigs = this.findPlugInConfigs();
        int i7 = 0;
        while (i7 < piconfigs.length) {
            piconfigs[i7].freeze();
            ++i7;
        }
    }

    public void removeActionConfig(ActionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        config.setModuleConfig(null);
        this.actionConfigs.remove(config.getPath());
        this.actionConfigList.remove(config);
    }

    public void removeExceptionConfig(ExceptionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.exceptions.remove(config.getType());
    }

    public void removeDataSourceConfig(DataSourceConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.dataSources.remove(config.getKey());
    }

    public void removeFormBeanConfig(FormBeanConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.formBeans.remove(config.getName());
    }

    public void removeForwardConfig(ForwardConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.forwards.remove(config.getName());
    }

    public void removeMessageResourcesConfig(MessageResourcesConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.messageResources.remove(config.getKey());
    }
}

