/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ClassMethodHyperlink
extends AbstractHyperlink {
    protected abstract String getMethodName(IRegion var1);

    protected abstract String getClassName(IRegion var1);

    @Override
    protected void doHyperlink(IRegion region) {
        try {
            String className = this.getClassName(region);
            String methodName = this.getMethodName(region);
            IJavaElement classMethod = null;
            if (className != null && className.trim().length() > 0) {
                classMethod = this.searchForClassMethod(className, methodName);
            }
            if (classMethod != null) {
                IEditorPart part = JavaUI.openInEditor(classMethod);
                if (part != null) {
                    JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)classMethod);
                } else {
                    this.openFileFailed();
                }
            } else {
                this.openFileFailed();
            }
        }
        catch (CoreException coreException) {
            this.openFileFailed();
        }
    }

    protected IJavaElement searchForClassMethod(IJavaProject javaProject, String className, String methodName) {
        SearchPattern pattern = SearchPattern.createPattern((String)(String.valueOf(className) + "." + methodName), (int)1, (int)0, (int)8);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
        final ArrayList matches = new ArrayList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                matches.add(match);
            }
        };
        SearchEngine searchEngine = new SearchEngine();
        try {
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
        }
        catch (CoreException coreException) {}
        Iterator i = matches.iterator();
        if (i != null && i.hasNext()) {
            return (IJavaElement)((SearchMatch)i.next()).getElement();
        }
        return null;
    }

    protected IJavaElement searchForClassMethod(String className, String methodName) {
        IFile documentFile = this.getFile();
        IJavaElement result = null;
        try {
            IProject project = null;
            if (documentFile == null) {
                IWorkbenchPage workbenchPage = ExtensionsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart activeEditorPart = workbenchPage.getActiveEditor();
                IEditorInput editorInput = activeEditorPart.getEditorInput();
                if (editorInput instanceof IStorageEditorInput) {
                    IStorageEditorInput moeInput = (IStorageEditorInput)editorInput;
                    IPath p = moeInput.getStorage().getFullPath();
                    String s0 = p.segment(0);
                    project = ResourcesPlugin.getWorkspace().getRoot().getProject(s0);
                }
            } else {
                project = documentFile.getProject();
            }
            if (project != null && project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                result = this.searchForClassMethod(javaProject, className, methodName);
            }
        }
        catch (CoreException x) {
            ExtensionsPlugin.getPluginLog().logError("Error while looking for method " + methodName + " of class " + className, (Throwable)x);
        }
        return result;
    }

    protected String getAttributeValue(Node node, String attrName) {
        try {
            Attr attr = (Attr)node.getAttributes().getNamedItem(attrName);
            return Utils.getTrimmedValue(this.getDocument(), attr);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected String getAttributeValue(IRegion region, String attrName) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, region.getOffset());
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            Element node = ((Attr)n).getOwnerElement();
            Attr attr = (Attr)node.getAttributes().getNamedItem(attrName);
            String string = Utils.getTrimmedValue(this.getDocument(), attr);
            return string;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        finally {
            smw.dispose();
        }
    }
}

