/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink;

import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkPartitionerBuilder;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkPartitionerDefinition;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.xpl.BaseHyperlinkDetector;
import org.jboss.tools.common.text.ext.util.AxisUtil;

public class HyperlinkDetector
extends BaseHyperlinkDetector {
    private static HyperlinkDetector fInstance;

    public static HyperlinkDetector getInstance() {
        return HyperlinkDetectorHolder.INSTANCE;
    }

    @Override
    protected IHyperlinkRegion[] getPartitions(IDocument document, int offset) {
        String documentRegionType = null;
        ITypedRegion region = null;
        ArrayList<IHyperlinkRegion> regions = new ArrayList<IHyperlinkRegion>();
        ITypedRegion iTypedRegion = region = document instanceof IDocumentExtension3 ? ((IDocumentExtension3)document).getDocumentPartitioner("org.eclipse.wst.sse.core.default_structured_text_partitioning").getPartition(offset) : document.getDocumentPartitioner().getPartition(offset);
        if (region != null) {
            documentRegionType = region.getType();
            String contentType = this.getContentType(document);
            HyperlinkRegion documentRegion = new HyperlinkRegion(region.getOffset(), region.getLength(), null, contentType, region.getType());
            HyperlinkPartitionerDefinition[] defs = HyperlinkPartitionerBuilder.getInstance().getHyperlinkPartitionerDefinitions(contentType, documentRegionType, null);
            if (defs == null || defs.length == 0) {
                regions.add(documentRegion);
            } else {
                int i = 0;
                while (i < defs.length) {
                    IHyperlinkRegion childRegion;
                    ITypedRegion finalDocumentRegion = region;
                    IDocument finalDocument = document;
                    String finalContentType = contentType;
                    IHyperlinkPartitioner hyperlinkPartitioner = defs[i].createHyperlinkPartitioner();
                    HyperlinkRegion startHyperlinkRegion = new HyperlinkRegion(finalDocumentRegion.getOffset(), finalDocumentRegion.getLength(), AxisUtil.getAxis(finalDocument, finalDocumentRegion.getOffset()), finalContentType, finalDocumentRegion.getType());
                    if (!(hyperlinkPartitioner instanceof IHyperlinkPartitionRecognizer && !((IHyperlinkPartitionRecognizer)((Object)hyperlinkPartitioner)).recognize(document, offset, startHyperlinkRegion) || (childRegion = hyperlinkPartitioner.getChildPartitionRegion(document, offset, startHyperlinkRegion)) == null || regions.contains(childRegion))) {
                        regions.add(childRegion);
                    }
                    ++i;
                }
            }
        }
        return regions.toArray(new IHyperlinkRegion[regions.size()]);
    }

    static class HyperlinkDetectorHolder {
        static HyperlinkDetector INSTANCE = new HyperlinkDetector();

        HyperlinkDetectorHolder() {
        }
    }
}

