/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xml;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;

public class PortletHyperlink
extends AbstractHyperlink {
    private static final String PROP_EXTENSION = ".properties";
    private String hyperlinkText = "";
    private String partitionType = null;

    @Override
    protected void doHyperlink(IRegion region) {
        if (region == null) {
            return;
        }
        try {
            IDocument document = this.getDocument();
            this.hyperlinkText = document.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException ex) {
            ExtensionsPlugin.getPluginLog().logError((Throwable)ex);
        }
        if (this.partitionType == "org.jboss.tools.common.text.ext.hyperlink.xml.PORTLET_CLASS") {
            this.doPortletClassHyperlink(region);
        } else if (this.partitionType == "org.jboss.tools.common.text.ext.hyperlink.xml.PORTLET_RESOURCE") {
            this.doPortletResourceBundleHyperlink(region);
        }
    }

    private void doPortletClassHyperlink(IRegion region) {
        IJavaProject javaProject;
        IEditorPart part = null;
        IProject project = this.getProject();
        if (project != null && (javaProject = EclipseResourceUtil.getJavaProject((IProject)project)) != null) {
            IFile file;
            IResource resource;
            IType type = null;
            try {
                type = EclipseJavaUtil.findType((IJavaProject)javaProject, (String)this.hyperlinkText);
            }
            catch (JavaModelException ex) {
                ExtensionsPlugin.getPluginLog().logError((Throwable)ex);
            }
            if (type != null && (resource = type.getResource()) != null && resource instanceof IFile && (file = (IFile)resource) != null) {
                part = PortletHyperlink.openFileInEditor(file);
            }
        }
        if (part == null) {
            this.openFileFailed();
        }
    }

    private void doPortletResourceBundleHyperlink(IRegion region) {
        String fileName = new String(this.hyperlinkText);
        if (!fileName.endsWith(PROP_EXTENSION)) {
            fileName = String.valueOf(fileName) + PROP_EXTENSION;
        }
        IFile file = this.getFileFromProject(fileName);
        IEditorPart part = null;
        if (file != null) {
            part = PortletHyperlink.openFileInEditor(file);
        }
        if (part == null) {
            this.openFileFailed();
        }
    }

    private IProject getProject() {
        IFile documentFile = this.getFile();
        if (documentFile == null || !documentFile.isAccessible()) {
            return null;
        }
        IProject project = documentFile.getProject();
        return project;
    }

    @Override
    public String getHyperlinkText() {
        return this.hyperlinkText;
    }
}

