/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xml;

import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLXmlNsHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String XML_XMLNS_PARTITION = "org.jboss.tools.common.text.ext.xml.XML_XMLNS";

    @Override
    protected IHyperlinkRegion parse(IDocument document, int offset, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, offset);
            if (!(n instanceof IDOMAttr)) {
                return null;
            }
            IDOMAttr xmlnsAttr = (IDOMAttr)n;
            if (xmlnsAttr.getName() == null || !xmlnsAttr.getName().startsWith("xmlns:") && !xmlnsAttr.getName().endsWith(":schemaLocation")) {
                return null;
            }
            xmlnsAttr.getValueRegionText();
            int start = Utils.getValueStart(n);
            int end = Utils.getValueEnd(n);
            String axis = this.getAxis(document, offset);
            String contentType = superRegion.getContentType();
            String type = XML_XMLNS_PARTITION;
            HyperlinkRegion hyperlinkRegion = new HyperlinkRegion(start, end - start, axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    @Override
    public boolean recognize(IDocument document, int offset, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, offset);
            if (!(n instanceof IDOMAttr)) {
                return false;
            }
            IDOMAttr xmlnsAttr = (IDOMAttr)n;
            if (xmlnsAttr.getName() == null || !xmlnsAttr.getName().equals("xmlns") && !xmlnsAttr.getName().startsWith("xmlns:") && !xmlnsAttr.getName().endsWith(":schemaLocation")) {
                return false;
            }
            Element rootElement = xmlnsAttr.getOwnerElement();
            return rootElement instanceof IDOMElement;
            {
            }
        }
        finally {
            smw.dispose();
        }
    }
}

