/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xpl;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SearchPattern;
import org.jboss.tools.common.text.ext.hyperlink.xpl.AbstractInformationControl;

public class HierarchyInformationControl
extends AbstractInformationControl {
    private IHyperlink[] hyperlinks;
    private BeanTableLabelProvider fLabelProvider;
    protected static Color gray = new Color(null, 128, 128, 128);
    protected static Color black = Display.getDefault().getSystemColor(28);
    protected static StyledString.Styler NAME_STYLE = new DefaultStyler(black, false);
    protected static StyledString.Styler PACKAGE_STYLE = new DefaultStyler(gray, false);

    public HierarchyInformationControl(Shell parent, String title, int shellStyle, int tableStyle, IHyperlink[] hyperlinks) {
        super(parent, shellStyle, tableStyle, "org.eclipse.jdt.ui.edit.text.java.open.hierarchy", true);
        this.hyperlinks = hyperlinks;
        this.setTitleText(title);
    }

    @Override
    protected boolean hasHeader() {
        return true;
    }

    @Override
    protected TableViewer createTableViewer(Composite parent, int style) {
        Table table = new Table(parent, 4 | style & 0xFFFFFFFD);
        GridData gd = new GridData(1808);
        gd.heightHint = table.getItemHeight() * 12;
        table.setLayoutData((Object)gd);
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.addFilter((ViewerFilter)new BeanFilter());
        this.fLabelProvider = this.createTableLableProvider();
        tableViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        return tableViewer;
    }

    protected BeanTableLabelProvider createTableLableProvider() {
        return new BeanTableLabelProvider();
    }

    @Override
    public void setInput(Object information) {
        if (!(information instanceof IHyperlink[])) {
            this.inputChanged(null, null);
            return;
        }
        this.hyperlinks = (IHyperlink[])information;
        BeanTableContentProvider contentProvider = new BeanTableContentProvider(this.hyperlinks);
        this.getTableViewer().setContentProvider((IContentProvider)contentProvider);
        this.inputChanged(this.hyperlinks, this.hyperlinks[0]);
    }

    @Override
    protected Object getSelectedElement() {
        Object selectedElement = super.getSelectedElement();
        return selectedElement;
    }

    @Override
    protected String getId() {
        return "org.jboss.tools.cdi.text.ext.InformationControl";
    }

    protected boolean select2(SearchPattern patternMatcher, Object element) {
        return true;
    }

    public class BeanFilter
    extends ViewerFilter {
        SearchPattern patternMatcher = new SearchPattern();

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return HierarchyInformationControl.this.select2(this.patternMatcher, element);
        }
    }

    public static class BeanTableContentProvider
    implements IStructuredContentProvider {
        private IHyperlink[] hyperlinks;

        public BeanTableContentProvider(IHyperlink[] beans) {
            this.hyperlinks = beans;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.hyperlinks;
        }
    }

    protected class BeanTableLabelProvider
    extends StyledCellLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        protected BeanTableLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            StyledString styledString = this.getStyledText(element);
            cell.setText(styledString.getString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.getImage(element));
            super.update(cell);
        }

        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }

        public StyledString getStyledText(Object element) {
            StyledString sb = new StyledString();
            if (element instanceof IHyperlink) {
                sb.append(((IHyperlink)element).getHyperlinkText(), NAME_STYLE);
            }
            return sb;
        }

        public Image getImage(Object element) {
            return null;
        }
    }

    private static class DefaultStyler
    extends StyledString.Styler {
        private final Color foreground;
        private final boolean italic;

        public DefaultStyler(Color foreground, boolean italic) {
            this.foreground = foreground;
            this.italic = italic;
        }

        public void applyStyles(TextStyle textStyle) {
            if (this.foreground != null) {
                textStyle.foreground = this.foreground;
            }
            if (this.italic) {
                textStyle.font = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }
        }
    }
}

