/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xpl;

import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.text.ext.hyperlink.xpl.HierarchyInformationControl;

public class InformationPresenter
extends AbstractInformationControlManager {
    private ITextViewer viwer;

    public InformationPresenter(ITextViewer viwer, IInformationControlCreator creator) {
        super(creator);
        this.viwer = viwer;
        this.setCloser(new Closer());
    }

    public void showInformation() {
        this.showInformation_internal(false);
    }

    private IInformationControl showInformation_internal(boolean test) {
        IInformationControl iControl = this.getInformationControl();
        Point sizeConstraints = this.computeSizeConstraints((Control)this.viwer.getTextWidget(), null, iControl);
        iControl.setSizeConstraints(sizeConstraints.x, sizeConstraints.y);
        Point size = null;
        Rectangle bounds = this.restoreInformationControlBounds();
        if (bounds != null && bounds.width > -1 && bounds.height > -1) {
            size = Geometry.getSize((Rectangle)bounds);
        }
        if (size == null) {
            size = iControl.computeSizeHint();
        }
        size = Geometry.max((Point)size, (Point)sizeConstraints);
        iControl.setSize(size.x, size.y);
        if (test) {
            ((HierarchyInformationControl)iControl).setBlockOnOpen(false);
        }
        iControl.setVisible(true);
        return iControl;
    }

    public IInformationControl showInformationForTest() {
        return this.showInformation_internal(true);
    }

    protected void computeInformation() {
        this.setInformation("Information", new Rectangle(1, 1, 100, 100));
    }

    class Closer
    implements AbstractInformationControlManager.IInformationControlCloser,
    ControlListener,
    MouseListener,
    FocusListener,
    IViewportListener,
    KeyListener {
        private Control fSubjectControl;
        private IInformationControl fInformationControlToClose;
        private boolean fIsActive = false;

        Closer() {
        }

        public void setSubjectControl(Control control) {
            this.fSubjectControl = control;
        }

        public void setInformationControl(IInformationControl control) {
            this.fInformationControlToClose = control;
        }

        public void start(Rectangle informationArea) {
            if (this.fIsActive) {
                return;
            }
            this.fIsActive = true;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addControlListener((ControlListener)this);
                this.fSubjectControl.addMouseListener((MouseListener)this);
                this.fSubjectControl.addFocusListener((FocusListener)this);
                this.fSubjectControl.addKeyListener((KeyListener)this);
            }
            if (this.fInformationControlToClose != null) {
                this.fInformationControlToClose.addFocusListener((FocusListener)this);
            }
            InformationPresenter.this.viwer.addViewportListener((IViewportListener)this);
        }

        public void stop() {
            if (!this.fIsActive) {
                return;
            }
            this.fIsActive = false;
            InformationPresenter.this.viwer.removeViewportListener((IViewportListener)this);
            if (this.fInformationControlToClose != null) {
                this.fInformationControlToClose.removeFocusListener((FocusListener)this);
            }
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeControlListener((ControlListener)this);
                this.fSubjectControl.removeMouseListener((MouseListener)this);
                this.fSubjectControl.removeFocusListener((FocusListener)this);
                this.fSubjectControl.removeKeyListener((KeyListener)this);
            }
        }

        public void controlResized(ControlEvent e) {
            InformationPresenter.this.hideInformationControl();
        }

        public void controlMoved(ControlEvent e) {
            InformationPresenter.this.hideInformationControl();
        }

        public void mouseDown(MouseEvent e) {
            InformationPresenter.this.hideInformationControl();
        }

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
            InformationPresenter.this.hideInformationControl();
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            Display d = this.fSubjectControl.getDisplay();
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (Closer.this.fInformationControlToClose == null || !Closer.this.fInformationControlToClose.isFocusControl()) {
                        InformationPresenter.this.hideInformationControl();
                    }
                }
            });
        }

        public void viewportChanged(int topIndex) {
            InformationPresenter.this.hideInformationControl();
        }

        public void keyPressed(KeyEvent e) {
            InformationPresenter.this.hideInformationControl();
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

