/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.text.xpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.document.NodeContainer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.jboss.tools.common.text.xml.XmlEditorPlugin;
import org.jboss.tools.common.text.xml.ui.xpl.ISelectionListenerWithSM;
import org.jboss.tools.common.text.xml.ui.xpl.SelectionListenerWithSMManager;
import org.jboss.tools.common.text.xml.ui.xpl.UIMessages;
import org.jboss.tools.jst.jsp.preferences.xpl.PreferenceKeyGenerator;
import org.jboss.tools.jst.jsp.preferences.xpl.XMLOccurrencePreferenceConstants;
import org.jboss.tools.jst.jsp.text.xpl.IStructuredTextOccurrenceStructureProvider;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DefaultStructuredTextOccurrenceStructureProvider
implements IStructuredTextOccurrenceStructureProvider {
    private OccurrencesFinderJob fOccurrencesFinderJob;
    private OccurrencesFinderJobCanceler fOccurrencesFinderJobCanceler;
    private ISelectionListenerWithSM fPostSelectionListenerWithSM;
    private IPreferenceStore fPreferenceStore;
    private String fEditorID;
    private IPropertyChangeListener fPropertyChangeListener = new PropertyChangeListener();
    private Annotation[] fOccurrenceAnnotations = null;
    private ISelection fForcedMarkOccurrencesSelection;
    private boolean fMarkOccurrenceAnnotations = true;
    private boolean fStickyOccurrenceAnnotations;
    private boolean fMarkNodeOccurrences;
    private boolean fMarkAttributeOccurrences;
    private boolean fMarkAttributeValueOccurrences;
    private boolean fMarkTextOccurrences;
    private String fOccurrenceProvider;
    private StructuredTextEditor fEditor;
    private ProjectionViewer fViewer;

    public DefaultStructuredTextOccurrenceStructureProvider(String editorID, IPreferenceStore store) {
        this.fEditorID = editorID;
        this.fPreferenceStore = store;
    }

    public Object getLockObject(IAnnotationModel annotationModel) {
        if (annotationModel instanceof ISynchronizable) {
            return ((ISynchronizable)annotationModel).getLockObject();
        }
        return annotationModel;
    }

    @Override
    public void install(StructuredTextEditor editor, ProjectionViewer viewer) {
        this.fEditor = editor;
        this.fViewer = viewer;
        this.initialize();
        if (this.fMarkOccurrenceAnnotations) {
            this.installOccurrencesFinder();
        }
    }

    @Override
    public void uninstall() {
        this.fMarkOccurrenceAnnotations = false;
        this.uninstallOccurrencesFinder();
        this.fPreferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
    }

    @Override
    public void initialize() {
        this.fPreferenceStore.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fMarkOccurrenceAnnotations = this.fPreferenceStore.getBoolean(PreferenceKeyGenerator.generateKey("markOccurrences", this.fEditorID));
        this.fMarkNodeOccurrences = this.fPreferenceStore.getBoolean(PreferenceKeyGenerator.generateKey("editor_mark_node_occurences", this.fEditorID));
        this.fMarkAttributeOccurrences = this.fPreferenceStore.getBoolean(PreferenceKeyGenerator.generateKey("editor_mark_attribute_occurrences", this.fEditorID));
        this.fMarkAttributeValueOccurrences = this.fPreferenceStore.getBoolean(PreferenceKeyGenerator.generateKey("editor_mark_attribute_value_occurrences", this.fEditorID));
        this.fMarkTextOccurrences = this.fPreferenceStore.getBoolean(PreferenceKeyGenerator.generateKey("editor_mark_text_occurrences", this.fEditorID));
        this.fStickyOccurrenceAnnotations = this.fPreferenceStore.getBoolean(PreferenceKeyGenerator.generateKey("stickyOccurrences", this.fEditorID));
    }

    ProjectionViewer getSourceViewer() {
        return this.fViewer;
    }

    protected void installOccurrencesFinder() {
        this.fPostSelectionListenerWithSM = new ISelectionListenerWithSM(){

            @Override
            public void selectionChanged(IEditorPart part, ITextSelection selection, IStructuredModel model) {
                DefaultStructuredTextOccurrenceStructureProvider.this.updateOccurrenceAnnotations(selection, model);
            }
        };
        SelectionListenerWithSMManager.getDefault().addListener((ITextEditor)this.fEditor, this.fPostSelectionListenerWithSM);
        if (this.fEditor.getSelectionProvider() != null) {
            this.fForcedMarkOccurrencesSelection = this.fEditor.getSelectionProvider().getSelection();
            SelectionListenerWithSMManager.getDefault().forceSelectionChange((ITextEditor)this.fEditor, (ITextSelection)this.fForcedMarkOccurrencesSelection);
        }
        if (this.fOccurrencesFinderJobCanceler == null) {
            this.fOccurrencesFinderJobCanceler = new OccurrencesFinderJobCanceler();
            this.fOccurrencesFinderJobCanceler.install();
        }
    }

    protected void uninstallOccurrencesFinder() {
        this.fMarkOccurrenceAnnotations = false;
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
            this.fOccurrencesFinderJob = null;
        }
        if (this.fOccurrencesFinderJobCanceler != null) {
            this.fOccurrencesFinderJobCanceler.uninstall();
            this.fOccurrencesFinderJobCanceler = null;
        }
        if (this.fPostSelectionListenerWithSM != null) {
            SelectionListenerWithSMManager.getDefault().removeListener((ITextEditor)this.fEditor, this.fPostSelectionListenerWithSM);
            this.fPostSelectionListenerWithSM = null;
        }
        this.removeOccurrenceAnnotations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        IDocumentProvider documentProvider = this.fEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOccurrenceAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                    ++i;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection, IStructuredModel model) {
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
        }
        if (!this.fMarkOccurrenceAnnotations) {
            return;
        }
        if (model == null || selection == null) {
            return;
        }
        IDocument document = this.getSourceViewer().getDocument();
        if (document == null) {
            return;
        }
        IDOMDocument dom = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
        List matches = this.findMatches((Document)dom, model, selection);
        if (matches == null || matches.size() == 0) {
            if (!this.fStickyOccurrenceAnnotations) {
                this.removeOccurrenceAnnotations();
            }
            return;
        }
        ArrayList<Position> positionsList = new ArrayList<Position>();
        for (Object current : matches) {
            if (current instanceof IDOMElement) {
                IDOMElement currentNode = (IDOMElement)current;
                int start = currentNode.getStartOffset();
                int end = currentNode.getStartEndOffset();
                positionsList.add(new Position(start, end - start));
                if (!currentNode.hasEndTag()) continue;
                start = currentNode.getEndStartOffset();
                end = currentNode.getEndOffset();
                positionsList.add(new Position(start, end - start));
                continue;
            }
            if (current instanceof ITextRegion) {
                ITextRegion currentRegion = (ITextRegion)current;
                positionsList.add(new Position(currentRegion.getStart(), currentRegion.getLength()));
                continue;
            }
            if (!(current instanceof Position)) continue;
            Position currentPosition = (Position)current;
            positionsList.add(new Position(currentPosition.getOffset(), currentPosition.getLength()));
        }
        if (positionsList.size() == 0) {
            return;
        }
        this.fOccurrencesFinderJob = new OccurrencesFinderJob(document, positionsList.toArray(new Position[positionsList.size()]), (ISelection)selection);
        this.fOccurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    private List findMatches(Document dom, IStructuredModel model, ITextSelection selection) {
        try {
            IndexedRegion region = ((IDOMModel)model).getIndexedRegion(selection.getOffset());
            if (region instanceof IDOMElement) {
                IDOMElement xmlElement = (IDOMElement)region;
                NamedNodeMap attrs = xmlElement.getAttributes();
                int i = 0;
                while (attrs != null && i < attrs.getLength()) {
                    IDOMAttr xmlAttr = (IDOMAttr)attrs.item(i);
                    if (xmlAttr.contains(selection.getOffset())) {
                        if (selection.getOffset() >= xmlAttr.getNameRegionStartOffset() && selection.getOffset() <= xmlAttr.getNameRegionEndOffset()) {
                            return this.findTagAttrNameMatches(dom, xmlElement.getTagName(), xmlAttr.getName());
                        }
                        if (selection.getOffset() >= xmlAttr.getValueRegionStartOffset() && selection.getOffset() <= xmlAttr.getEndOffset()) {
                            return this.findTagAttrValueMatches(dom, xmlAttr.getValue());
                        }
                    }
                    ++i;
                }
                return this.findTagMatches(dom, xmlElement.getTagName());
            }
            if (region instanceof IDOMText) {
                IDOMText xmlText = (IDOMText)region;
                return this.findTextMatches(dom, xmlText.getData().trim());
            }
        }
        catch (DOMException x) {
            XmlEditorPlugin.getPluginLog().logError((Throwable)x);
        }
        return new ArrayList();
    }

    private List findTagMatches(Document dom, String tagName) {
        ArrayList matches = new ArrayList();
        if (this.fMarkNodeOccurrences) {
            NodeContainer children = (NodeContainer)dom.getChildNodes();
            int i = 0;
            while (children != null && i < children.getLength()) {
                if (children.item(i) instanceof IDOMNode) {
                    IDOMNode xmlNode = (IDOMNode)children.item(i);
                    this.addTagOccurencies(matches, xmlNode, tagName);
                }
                ++i;
            }
        }
        return matches;
    }

    private void addTagOccurencies(List matches, IDOMNode xmlNode, String tagName) {
        IDOMElement xmlElement;
        if (matches == null || xmlNode == null || tagName == null) {
            return;
        }
        if (xmlNode instanceof IDOMElement && tagName.equals((xmlElement = (IDOMElement)xmlNode).getTagName())) {
            matches.add(xmlElement);
        }
        Node child = xmlNode.getFirstChild();
        while (child != null) {
            if (child instanceof IDOMNode) {
                this.addTagOccurencies(matches, (IDOMNode)child, tagName);
            }
            child = child.getNextSibling();
        }
    }

    private List findTagAttrNameMatches(Document dom, String tagName, String attrName) {
        ArrayList matches = new ArrayList();
        if (this.fMarkAttributeOccurrences) {
            NodeContainer children = (NodeContainer)dom.getChildNodes();
            int i = 0;
            while (children != null && i < children.getLength()) {
                if (children.item(i) instanceof IDOMNode) {
                    IDOMNode xmlNode = (IDOMNode)children.item(i);
                    this.addTagAttrNameOccurencies(matches, xmlNode, attrName);
                }
                ++i;
            }
        }
        return matches;
    }

    private void addTagAttrNameOccurencies(List matches, IDOMNode xmlNode, String attrName) {
        if (matches == null || xmlNode == null || attrName == null) {
            return;
        }
        if (xmlNode instanceof IDOMElement) {
            IDOMElement xmlElement = (IDOMElement)xmlNode;
            NamedNodeMap attrs = xmlElement.getAttributes();
            int i = 0;
            while (attrs != null && i < attrs.getLength()) {
                IDOMAttr xmlAttr = (IDOMAttr)attrs.item(i);
                if (attrName.equals(xmlAttr.getName())) {
                    matches.add(new Position(xmlAttr.getNameRegionStartOffset(), xmlAttr.getNameRegionTextEndOffset() - xmlAttr.getNameRegionStartOffset()));
                }
                ++i;
            }
        }
        Node child = xmlNode.getFirstChild();
        while (child != null) {
            if (child instanceof IDOMNode) {
                this.addTagAttrNameOccurencies(matches, (IDOMNode)child, attrName);
            }
            child = child.getNextSibling();
        }
    }

    private List findTagAttrValueMatches(Document dom, String attrValue) {
        ArrayList matches = new ArrayList();
        if (this.fMarkAttributeValueOccurrences) {
            NodeContainer children = (NodeContainer)dom.getChildNodes();
            int i = 0;
            while (children != null && i < children.getLength()) {
                if (children.item(i) instanceof IDOMNode) {
                    IDOMNode xmlNode = (IDOMNode)children.item(i);
                    this.addTagAttrValueOccurencies(matches, xmlNode, attrValue);
                }
                ++i;
            }
        }
        return matches;
    }

    private void addTagAttrValueOccurencies(List matches, IDOMNode xmlNode, String attrValue) {
        if (matches == null || xmlNode == null || attrValue == null) {
            return;
        }
        if (xmlNode instanceof IDOMElement) {
            IDOMElement xmlElement = (IDOMElement)xmlNode;
            NamedNodeMap attrs = xmlElement.getAttributes();
            int i = 0;
            while (attrs != null && i < attrs.getLength()) {
                IDOMAttr xmlAttr = (IDOMAttr)attrs.item(i);
                String value = xmlAttr.getValueRegionText();
                if (attrValue.equals(xmlAttr.getValue())) {
                    matches.add(new Position(xmlAttr.getValueRegionStartOffset(), value == null ? 0 : value.length()));
                }
                ++i;
            }
        }
        Node child = xmlNode.getFirstChild();
        while (child != null) {
            if (child instanceof IDOMNode) {
                this.addTagAttrValueOccurencies(matches, (IDOMNode)child, attrValue);
            }
            child = child.getNextSibling();
        }
    }

    private List findTextMatches(Document dom, String data) {
        ArrayList matches = new ArrayList();
        if (this.fMarkTextOccurrences && !this.isEmptyString(data)) {
            NodeContainer children = (NodeContainer)dom.getChildNodes();
            int i = 0;
            while (children != null && i < children.getLength()) {
                if (children.item(i) instanceof IDOMNode) {
                    IDOMNode xmlNode = (IDOMNode)children.item(i);
                    this.addTextOccurencies(matches, xmlNode, data);
                }
                ++i;
            }
        }
        return matches;
    }

    private boolean isEmptyString(String str) {
        return str == null || str.trim().length() == 0;
    }

    private void addTextOccurencies(List matches, IDOMNode xmlNode, String data) {
        IDOMText xmlText;
        String xmlData;
        if (matches == null || xmlNode == null || data == null) {
            return;
        }
        if (xmlNode instanceof IDOMText && (xmlData = (xmlText = (IDOMText)xmlNode).getData()) != null && xmlData.indexOf(data) != -1) {
            matches.add(new Position(xmlText.getStartOffset() + xmlData.indexOf(data), data.length()));
        }
        Node child = xmlNode.getFirstChild();
        while (child != null) {
            if (child instanceof IDOMNode) {
                this.addTextOccurencies(matches, (IDOMNode)child, data);
            }
            child = child.getNextSibling();
        }
    }

    private boolean getEventNewBooleanValue(PropertyChangeEvent event) {
        return Boolean.getBoolean(event.getNewValue().toString());
    }

    @Override
    public void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        this.getSourceViewer();
        if (this.getSourceViewer() != null) {
            String property = event.getProperty();
            if (PreferenceKeyGenerator.generateKey("markOccurrences", this.fEditorID).equals(property)) {
                boolean markOccurrences = this.getEventNewBooleanValue(event);
                if (markOccurrences != this.fMarkOccurrenceAnnotations) {
                    this.fMarkOccurrenceAnnotations = markOccurrences;
                    if (!this.fMarkOccurrenceAnnotations) {
                        this.uninstallOccurrencesFinder();
                    } else {
                        this.installOccurrencesFinder();
                    }
                }
            } else if (PreferenceKeyGenerator.generateKey("editor_occurrence_provider", this.fEditorID).equals(property)) {
                String occurrenceProvider;
                if (event.getNewValue() instanceof String && (occurrenceProvider = (String)event.getNewValue()) != this.fOccurrenceProvider) {
                    this.fOccurrenceProvider = occurrenceProvider;
                    if (this.fMarkOccurrenceAnnotations) {
                        this.uninstallOccurrencesFinder();
                        this.installOccurrencesFinder();
                    }
                }
            } else if (PreferenceKeyGenerator.generateKey("editor_mark_node_occurences", this.fEditorID).equals(property)) {
                this.fMarkNodeOccurrences = this.getEventNewBooleanValue(event);
            } else if (PreferenceKeyGenerator.generateKey("editor_mark_attribute_occurrences", this.fEditorID).equals(property)) {
                this.fMarkAttributeOccurrences = this.getEventNewBooleanValue(event);
            } else if (PreferenceKeyGenerator.generateKey("editor_mark_attribute_value_occurrences", this.fEditorID).equals(property)) {
                this.fMarkAttributeValueOccurrences = this.getEventNewBooleanValue(event);
            } else if (PreferenceKeyGenerator.generateKey("editor_mark_text_occurrences", this.fEditorID).equals(property)) {
                this.fMarkAttributeValueOccurrences = this.getEventNewBooleanValue(event);
            } else if (PreferenceKeyGenerator.generateKey("stickyOccurrences", this.fEditorID).equals(property)) {
                this.fStickyOccurrenceAnnotations = this.getEventNewBooleanValue(event);
            }
        }
    }

    @Override
    public boolean affectsPreferences(String property) {
        return XMLOccurrencePreferenceConstants.affectsPreferences(property);
    }

    @Override
    public IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    @Override
    public String getEditorId() {
        return this.fEditorID;
    }

    protected class OccurrencesFinderJob
    extends Job {
        private IDocument fDocument;
        private ISelection fSelection;
        private ISelectionValidator fPostSelectionValidator;
        private boolean fCanceled;
        private IProgressMonitor fProgressMonitor;
        private Position[] fPositions;

        public OccurrencesFinderJob(IDocument document, Position[] positions, ISelection selection) {
            super(UIMessages.RedHatStructuredTextEditor_markOccurrences_job_name);
            this.fCanceled = false;
            this.fDocument = document;
            this.fSelection = selection;
            this.fPositions = positions;
            if (DefaultStructuredTextOccurrenceStructureProvider.this.fEditor.getSelectionProvider() instanceof ISelectionValidator) {
                this.fPostSelectionValidator = (ISelectionValidator)DefaultStructuredTextOccurrenceStructureProvider.this.fEditor.getSelectionProvider();
            }
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled() {
            return this.fCanceled || this.fProgressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && DefaultStructuredTextOccurrenceStructureProvider.this.fForcedMarkOccurrencesSelection != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            this.fProgressMonitor = progressMonitor;
            if (this.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ProjectionViewer textViewer = DefaultStructuredTextOccurrenceStructureProvider.this.getSourceViewer();
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = DefaultStructuredTextOccurrenceStructureProvider.this.fEditor.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)DefaultStructuredTextOccurrenceStructureProvider.this.fEditor.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            int length = this.fPositions.length;
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(length);
            int i = 0;
            while (i < length) {
                block16: {
                    String message;
                    if (this.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Position position = this.fPositions[i];
                    try {
                        message = document.get(position.offset, position.length);
                    }
                    catch (BadLocationException ex) {
                        XmlEditorPlugin.getPluginLog().logError((Throwable)ex);
                        break block16;
                    }
                    annotationMap.put(new Annotation("org.jboss.tools.jst.jsp.occurrences", false, message), position);
                }
                ++i;
            }
            if (this.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Object object = DefaultStructuredTextOccurrenceStructureProvider.this.getLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(DefaultStructuredTextOccurrenceStructureProvider.this.fOccurrenceAnnotations, annotationMap);
                } else {
                    DefaultStructuredTextOccurrenceStructureProvider.this.removeOccurrenceAnnotations();
                    for (Map.Entry mapEntry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                    }
                }
                DefaultStructuredTextOccurrenceStructureProvider.this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }
    }

    protected class OccurrencesFinderJobCanceler
    implements IDocumentListener,
    ITextInputListener {
        protected OccurrencesFinderJobCanceler() {
        }

        public void install() {
            ProjectionViewer sourceViewer = DefaultStructuredTextOccurrenceStructureProvider.this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            StyledText text = sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            sourceViewer.addTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void uninstall() {
            IDocument document;
            IDocumentProvider documentProvider;
            ProjectionViewer sourceViewer = DefaultStructuredTextOccurrenceStructureProvider.this.getSourceViewer();
            if (sourceViewer != null) {
                sourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            if ((documentProvider = DefaultStructuredTextOccurrenceStructureProvider.this.fEditor.getDocumentProvider()) != null && (document = documentProvider.getDocument((Object)DefaultStructuredTextOccurrenceStructureProvider.this.fEditor.getEditorInput())) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (DefaultStructuredTextOccurrenceStructureProvider.this.fOccurrencesFinderJob != null) {
                DefaultStructuredTextOccurrenceStructureProvider.this.fOccurrencesFinderJob.doCancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }
    }

    class PropertyChangeListener
    implements IPropertyChangeListener {
        PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            DefaultStructuredTextOccurrenceStructureProvider.this.handlePreferenceStoreChanged(event);
        }
    }
}

