/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.marker;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.common.preferences.SeverityPreferences;
import org.jboss.tools.common.quickfix.IBaseMarkerResolution;
import org.jboss.tools.common.ui.CommonUIMessages;
import org.jboss.tools.common.ui.preferences.SeverityPreferencePage;

public class ConfigureProblemSeverityMarkerResolution
implements IBaseMarkerResolution,
IJavaCompletionProposal {
    private static final int PREFERENCE_SIZE = 40;
    private static final String DOTS = "...";
    private IProject project;
    private String preferencePageId;
    private String propertyPageId;
    private String preferenceKey;
    private String pluginId;
    private String label;
    private SP preferences = new SP();

    public ConfigureProblemSeverityMarkerResolution(IProject project, String preferencePageId, String propertyPageId, String preferenceKey, String pluginId) {
        this.project = project;
        this.preferencePageId = preferencePageId;
        this.propertyPageId = propertyPageId;
        this.preferenceKey = preferenceKey;
        this.pluginId = pluginId;
        String preferenceName = this.getPreferenceLabel();
        this.label = NLS.bind((String)CommonUIMessages.CONFIGURE_PROBLEM_SEVERITY, (Object)preferenceName);
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        UIJob job = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IEclipsePreferences projectPreferences = ConfigureProblemSeverityMarkerResolution.this.preferences.getProjectPreferences(ConfigureProblemSeverityMarkerResolution.this.project);
                String projectValue = null;
                if (projectPreferences != null) {
                    projectValue = projectPreferences.get(ConfigureProblemSeverityMarkerResolution.this.preferenceKey, null);
                }
                if (projectValue != null) {
                    PreferencesUtil.createPropertyDialogOn((Shell)DebugUIPlugin.getShell(), (IAdaptable)ConfigureProblemSeverityMarkerResolution.this.project, (String)ConfigureProblemSeverityMarkerResolution.this.propertyPageId, (String[])new String[]{ConfigureProblemSeverityMarkerResolution.this.preferencePageId}, (Object)ConfigureProblemSeverityMarkerResolution.this.preferenceKey).open();
                } else {
                    PreferencesUtil.createPreferenceDialogOn((Shell)DebugUIPlugin.getShell(), (String)ConfigureProblemSeverityMarkerResolution.this.preferencePageId, (String[])new String[]{ConfigureProblemSeverityMarkerResolution.this.preferencePageId}, (Object)ConfigureProblemSeverityMarkerResolution.this.preferenceKey).open();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }

    public String getDescription() {
        return this.label;
    }

    public Image getImage() {
        return JavaPlugin.getImageDescriptorRegistry().get(JavaPluginImages.DESC_ELCL_CONFIGURE_PROBLEM_SEVERITIES);
    }

    private WorkbenchPreferenceNode findPageNode() {
        PreferenceManager preferenceManager = PlatformUI.getWorkbench().getPreferenceManager();
        List nodes = preferenceManager.getElements(1);
        for (IPreferenceNode node : nodes) {
            if (!node.getId().equals(this.preferencePageId)) continue;
            return (WorkbenchPreferenceNode)node;
        }
        return null;
    }

    private String getPreferenceLabel() {
        String label = "";
        WorkbenchPreferenceNode pageNode = this.findPageNode();
        if (pageNode != null) {
            IPreferencePage page = pageNode.getPage();
            if (page == null) {
                pageNode.createPage();
                page = pageNode.getPage();
                label = this.getLabel(page);
                pageNode.setPage(null);
                page.dispose();
            } else {
                label = this.getLabel(page);
            }
        }
        return label;
    }

    private String getLabel(IPreferencePage page) {
        if (page instanceof SeverityPreferencePage) {
            return this.cut(((SeverityPreferencePage)page).getLabel(this.preferenceKey));
        }
        return "";
    }

    private String cut(String label) {
        if (label.length() > 40) {
            return String.valueOf(label.substring(0, 39)) + DOTS;
        }
        if (label.endsWith(":")) {
            return label.substring(0, label.length() - 1);
        }
        return label;
    }

    public void apply(IDocument document) {
        this.run(null);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.label;
    }

    public String getDisplayString() {
        return this.label;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return 0;
    }

    class SP
    extends SeverityPreferences {
        SP() {
        }

        protected Set<String> getSeverityOptionNames() {
            return null;
        }

        protected String createSeverityOption(String shortName) {
            return null;
        }

        protected String getPluginId() {
            return ConfigureProblemSeverityMarkerResolution.this.pluginId;
        }
    }
}

