/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.validation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.validation.AsYouTypeValidatorManager;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.IValidatingProjectSet;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.IValidationContextManager;
import org.jboss.tools.common.validation.IValidator;
import org.jboss.tools.common.validation.JBTValidationException;

public class ValidatorManager
implements IValidatorJob {
    private static Set<IProject> validatingProjects = new HashSet<IProject>();
    public static final String SLEEPING = "Sleeping";
    public static final String RUNNING = "Running";
    private static String STATUS = "Sleeping";

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        STATUS = RUNNING;
        try {
            ContextValidationHelper validationHelper = (ContextValidationHelper)helper;
            IProject project = validationHelper.getProject();
            if (project == null) {
                IStatus iStatus = OK_STATUS;
                return iStatus;
            }
            IValidationContextManager validationContextManager = validationHelper.getValidationContextManager();
            Set<IProject> rootProjects = validationContextManager.getRootProjects();
            IStatus status = OK_STATUS;
            Set<IProject> set = validatingProjects;
            synchronized (set) {
                block35: {
                    rootProjects.removeAll(validatingProjects);
                    if (!rootProjects.isEmpty()) break block35;
                    IStatus iStatus = OK_STATUS;
                    return iStatus;
                }
                validatingProjects.addAll(rootProjects);
            }
            try {
                validationContextManager.clearValidatedProjectsList();
                Set<IFile> changedFiles = validationHelper.getChangedFiles();
                if (!(validationHelper.isClasspathAffected() || changedFiles.isEmpty() && validationHelper.getURIs().length <= 0)) {
                    status = this.validate(changedFiles, validationHelper, reporter, rootProjects);
                } else if (!validationContextManager.getRegisteredFiles().isEmpty()) {
                    validationContextManager.clearAllResourceLinks(rootProjects);
                    status = this.validateAll(validationHelper, reporter, rootProjects);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (validationContextManager != null) {
                        validationContextManager.clearRegisteredFiles();
                    }
                    validationHelper.cleanup();
                }
                catch (Throwable throwable2) {
                    Set<IProject> set2 = validatingProjects;
                    synchronized (set2) {
                        validatingProjects.removeAll(rootProjects);
                    }
                    throw throwable2;
                }
                Set<IProject> set3 = validatingProjects;
                synchronized (set3) {
                    validatingProjects.removeAll(rootProjects);
                }
                throw throwable;
            }
            try {
                if (validationContextManager != null) {
                    validationContextManager.clearRegisteredFiles();
                }
                validationHelper.cleanup();
            }
            catch (Throwable throwable) {
                Set<IProject> set4 = validatingProjects;
                synchronized (set4) {
                    validatingProjects.removeAll(rootProjects);
                }
                throw throwable;
            }
            Set<IProject> set5 = validatingProjects;
            synchronized (set5) {
                validatingProjects.removeAll(rootProjects);
            }
            IStatus iStatus = status;
            return iStatus;
        }
        catch (Exception e) {
            CommonPlugin.getDefault().logError((Throwable)new JBTValidationException(e.getMessage(), e));
            IStatus iStatus = OK_STATUS;
            return iStatus;
        }
        finally {
            STATUS = SLEEPING;
        }
    }

    private IStatus validate(Set<IFile> changedFiles, ContextValidationHelper validationHelper, IReporter reporter, Set<IProject> rootProjects) throws ValidationException {
        IValidationContextManager validationContextManager = validationHelper.getValidationContextManager();
        List<IValidator> validators = validationContextManager.getValidators();
        this.removeMarkers(changedFiles);
        AsYouTypeValidatorManager.removeMessages();
        for (IValidator validator : validators) {
            try {
                IValidatingProjectSet projectBrunch;
                IValidatingProjectTree tree = validationHelper.getValidationContextManager().getValidatingProjectTree(validator);
                if (tree == null) continue;
                HashSet<IProject> validateAll = new HashSet<IProject>();
                for (IProject rootProject : rootProjects) {
                    projectBrunch = tree.getBrunches().get(rootProject);
                    if (projectBrunch == null || !projectBrunch.isFullValidationRequired()) continue;
                    validateAll.add(rootProject);
                }
                for (IProject rootProject : validateAll) {
                    projectBrunch = tree.getBrunches().get(rootProject);
                    if (projectBrunch == null) continue;
                    projectBrunch.setFullValidationRequired(false);
                }
                for (IProject rootProject : rootProjects) {
                    projectBrunch = tree.getBrunches().get(rootProject);
                    if (projectBrunch == null) continue;
                    if (validateAll.contains(rootProject)) {
                        validator.validateAll(rootProject, validationHelper, projectBrunch.getRootContext(), this, reporter);
                        continue;
                    }
                    validator.validate(changedFiles, rootProject, validationHelper, projectBrunch.getRootContext(), this, reporter);
                }
            }
            catch (Exception e) {
                CommonPlugin.getDefault().logError((Throwable)new JBTValidationException(e.getMessage(), e));
            }
        }
        return OK_STATUS;
    }

    private IStatus validateAll(ContextValidationHelper validationHelper, IReporter reporter, Set<IProject> rootProjects) throws ValidationException {
        IValidationContextManager validationContextManager = validationHelper.getValidationContextManager();
        List<IValidator> validators = validationContextManager.getValidators();
        this.removeMarkers(validationHelper.getProjectSetRegisteredFiles());
        for (IValidator validator : validators) {
            try {
                IValidatingProjectTree tree = validationHelper.getValidationContextManager().getValidatingProjectTree(validator);
                if (tree == null) continue;
                for (IProject rootProject : rootProjects) {
                    IValidatingProjectSet projectBrunch = tree.getBrunches().get(rootProject);
                    if (projectBrunch == null) continue;
                    projectBrunch.setFullValidationRequired(false);
                    validator.validateAll(rootProject, validationHelper, projectBrunch.getRootContext(), this, reporter);
                }
            }
            catch (Exception e) {
                CommonPlugin.getDefault().logError((Throwable)new JBTValidationException(e.getMessage(), e));
            }
        }
        return OK_STATUS;
    }

    private void removeMarkers(Set<IFile> files) {
        try {
            for (IFile file : files) {
                if (!file.isAccessible()) continue;
                file.deleteMarkers("org.jboss.tools.common.validation.JBTValidationProblem", true, 0);
            }
        }
        catch (CoreException e) {
            CommonPlugin.getDefault().logError((Throwable)e);
        }
    }

    public void cleanup(IReporter reporter) {
        reporter = null;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validateInJob(helper, reporter);
    }

    public static String getStatus() {
        return STATUS;
    }

    public static void setStatus(String status) {
        STATUS = status;
    }
}

