/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.ui.vrules.wizard.config;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.wizards.query.AbstractQueryWizardView;
import org.jboss.tools.common.model.ui.wizards.query.list.TreeItemSelectionManager;
import org.jboss.tools.common.verification.ui.vrules.wizard.DescriptionManager;
import org.jboss.tools.common.verification.ui.vrules.wizard.config.ConfigItemWrapper;
import org.jboss.tools.common.verification.ui.vrules.wizard.config.ConfigRulesProvider;
import org.jboss.tools.common.verification.ui.vrules.wizard.config.ConfigSignificanceView;
import org.jboss.tools.common.verification.ui.vrules.wizard.config.RuleSetWrapper;
import org.jboss.tools.common.verification.ui.vrules.wizard.config.RuleWrapper;
import org.jboss.tools.common.verification.vrules.VHelper;
import org.jboss.tools.common.verification.vrules.VManager;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VRuleSet;

public class VRulesConfigurationWizardView
extends AbstractQueryWizardView {
    protected ConfigSignificanceView significance = new ConfigSignificanceView();
    protected TreeViewer treeViewer;
    protected ConfigRulesProvider provider = new ConfigRulesProvider();
    protected DescriptionManager tip = new DescriptionManager();

    public VRulesConfigurationWizardView() {
        this.setMessage(WizardKeys.getString((String)"VRulesConfigurationWizardView.Message"));
        this.setTitle(WizardKeys.getString((String)"VRulesConfigurationWizardView.Title"));
        this.setWindowTitle(WizardKeys.getString((String)"VRulesConfigurationWizardView.WindowTitle"));
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Control sc = this.significance.createControl(composite);
        sc.setLayoutData((Object)new GridData(768));
        this.treeViewer = new TreeViewer(composite, 2848);
        this.treeViewer.setContentProvider((IContentProvider)this.provider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.treeViewer.setInput((Object)this);
        Control tc = this.treeViewer.getControl();
        tc.setLayoutData((Object)new GridData(1808));
        TreeItemSelectionManager m = new TreeItemSelectionManager(this.treeViewer, (TreeItemSelectionManager.Listener)new Flipper());
        this.significance.update();
        this.tip.install((Control)this.treeViewer.getTree());
        this.treeViewer.expandToLevel(2);
        m.update();
        return composite;
    }

    public void setObject(Object data) {
        VManager manager;
        Properties p = this.findProperties(data);
        if (p != null) {
            String key = p.getProperty("help");
            this.setHelpKey(key);
        }
        if ((manager = VHelper.getManager()) == null) {
            return;
        }
        this.significance.setManager(manager);
        VRuleSet[] sets = manager.getRuleSets();
        RuleSetWrapper[] ruleSets = new RuleSetWrapper[sets == null ? 0 : sets.length];
        int i = 0;
        while (i < sets.length) {
            ruleSets[i] = new RuleSetWrapper(sets[i]);
            this.createChildren(ruleSets[i], sets[i]);
            ++i;
        }
        this.provider.ruleSets = ruleSets;
    }

    private void createChildren(RuleSetWrapper ruleSetWrapper, VRuleSet set) {
        ArrayList<ConfigItemWrapper> list = new ArrayList<ConfigItemWrapper>();
        VRuleSet[] ss = set.getRuleSets();
        int j = 0;
        while (j < ss.length) {
            RuleSetWrapper c = new RuleSetWrapper(ss[j]);
            this.createChildren(c, ss[j]);
            c.setParent(ruleSetWrapper);
            list.add(c);
            ++j;
        }
        VRule[] rs = set.getRules();
        int j2 = 0;
        while (j2 < rs.length) {
            list.add(new RuleWrapper(rs[j2], this.significance, ruleSetWrapper));
            ++j2;
        }
        ruleSetWrapper.children = list.toArray(new ConfigItemWrapper[0]);
    }

    public void action(String command) {
        this.stopEditing();
        if (CANCEL.equals(command)) {
            this._cancel();
            this.setCode(1);
            this.dispose();
        } else if (OK.equals(command)) {
            this.significance.commit();
            PreferenceModelUtilities.getPreferenceModel().save();
            this.setCode(0);
            this.dispose();
        }
    }

    private void _cancel() {
        RuleSetWrapper[] ruleSets = this.provider.getRuleSets();
        int i = 0;
        while (i < ruleSets.length) {
            ruleSets[i].cancel();
            ++i;
        }
    }

    class Flipper
    implements TreeItemSelectionManager.Listener {
        Flipper() {
        }

        public void flip(TreeItem item) {
            ConfigItemWrapper w = (ConfigItemWrapper)item.getData();
            ConfigItemWrapper p = w.getParent();
            while (p != null) {
                if (!p.isSelected()) {
                    return;
                }
                p = p.getParent();
            }
            w.flip();
            VRulesConfigurationWizardView.this.treeViewer.refresh((Object)w);
        }

        public boolean isSelected(Object data) {
            ConfigItemWrapper w = (ConfigItemWrapper)data;
            return w.isSelected();
        }
    }
}

