/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.ui.vrules.wizard.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.wizards.query.AbstractQueryWizardView;
import org.jboss.tools.common.verification.ui.XStudioVerificationPlugin;
import org.jboss.tools.common.verification.ui.vrules.preferences.VerificationPreferencePage;
import org.jboss.tools.common.verification.ui.vrules.wizard.DescriptionManager;
import org.jboss.tools.common.verification.ui.vrules.wizard.runtime.RuntimeItemWrapper;
import org.jboss.tools.common.verification.ui.vrules.wizard.runtime.RuntimeItemWrapperListener;
import org.jboss.tools.common.verification.ui.vrules.wizard.runtime.RuntimeRuleSetWrapper;
import org.jboss.tools.common.verification.ui.vrules.wizard.runtime.RuntimeRuleWrapper;
import org.jboss.tools.common.verification.ui.vrules.wizard.runtime.RuntimeRulesProvider;
import org.jboss.tools.common.verification.ui.vrules.wizard.runtime.RuntimeSignificanceView;
import org.jboss.tools.common.verification.ui.vrules.wizard.runtime.VTaskListenerImpl;
import org.jboss.tools.common.verification.ui.vrules.wizard.runtime.VTaskListenerSafeImpl;
import org.jboss.tools.common.verification.ui.vrules.wizard.runtime.VerificationUIMessages;
import org.jboss.tools.common.verification.vrules.VHelper;
import org.jboss.tools.common.verification.vrules.VManager;
import org.jboss.tools.common.verification.vrules.VModel;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VRuleSet;
import org.jboss.tools.common.verification.vrules.VTask;
import org.jboss.tools.common.verification.vrules.VTaskListener;
import org.jboss.tools.common.verification.vrules.layer.VModelFactory;

public class VerifyWizardView
extends AbstractQueryWizardView {
    private static final String COMMAND_RESUME = VerificationUIMessages.VerifyWizardView_Resume;
    private static final String COMMAND_PAUSE = VerificationUIMessages.VerifyWizardView_Pause;
    private static final String COMMAND_STOP = VerificationUIMessages.VerifyWizardView_Stop;
    private static final String COMMAND_RUN_SELECTED = VerificationUIMessages.VerifyWizardView_RunSelected;
    private static final String COMMAND_RUN_ALL = VerificationUIMessages.VerifyWizardView_RunAll;
    static final String COMMAND_CLOSE = VerificationUIMessages.VerifyWizardView_Close;
    static String[] INITIAL_COMMANDS = new String[]{COMMAND_RUN_ALL, COMMAND_RUN_SELECTED, COMMAND_CLOSE, HELP};
    static String[] RUNNING_COMMANDS = new String[]{COMMAND_PAUSE, COMMAND_STOP, COMMAND_CLOSE, HELP};
    static String[] PAUSE_COMMANDS = new String[]{COMMAND_RESUME, COMMAND_STOP, COMMAND_CLOSE, HELP};
    protected RuntimeSignificanceView significance = new RuntimeSignificanceView();
    protected RuntimeRulesProvider provider = new RuntimeRulesProvider();
    protected TreeViewer treeViewer;
    protected XModel model;
    protected VObject vobject;
    protected VTask task = null;
    protected VTaskListener listener = new VTaskListenerSafeImpl(new VTaskListenerImpl(this));
    protected Map<String, RuntimeItemWrapper> wrappers = new HashMap<String, RuntimeItemWrapper>();
    protected DescriptionManager tip = new DescriptionManager();
    static int ERROR_COUMT_LIMIT = -1;
    boolean limitLock = false;

    public VerifyWizardView() {
        this.setMessage(WizardKeys.getString((String)"VerifyWizardView.Message"));
        this.setTitle(WizardKeys.getString((String)"VerifyWizardView.Title"));
        this.setWindowTitle(WizardKeys.getString((String)"VerifyWizardView.WindowTitle"));
    }

    private VManager getRulesManager() {
        return VHelper.getManager();
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Control sc = this.significance.createControl(composite);
        sc.setLayoutData((Object)new GridData(768));
        this.treeViewer = new TreeViewer(composite, 2818);
        this.treeViewer.setContentProvider((IContentProvider)this.provider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.treeViewer.setInput((Object)this);
        Control tc = this.treeViewer.getControl();
        tc.setLayoutData((Object)new GridData(1808));
        this.significance.update();
        this.tip.install((Control)this.treeViewer.getTree());
        this.treeViewer.expandToLevel(2);
        return composite;
    }

    public void setObject(Object data) {
        Properties p = this.findProperties(data);
        if (p != null) {
            String key = p.getProperty("help");
            this.setHelpKey(key);
        }
        Object[] os = (Object[])data;
        XModelObject object = (XModelObject)os[0];
        this.model = object.getModel();
        VManager rulesManager = this.getRulesManager();
        this.significance.setManager(rulesManager);
        VModel vmodel = VModelFactory.getModel((XModel)object.getModel());
        this.vobject = vmodel.getObjectByPath(object.getPath());
        VRule[] rules = VHelper.getRules((VManager)rulesManager, (VObject)this.vobject);
        if (rules == null) {
            return;
        }
        VRuleSet[] sets = this.getRuleSets(rules);
        RuntimeRuleSetWrapper[] ruleSets = new RuntimeRuleSetWrapper[sets.length];
        if (sets != null) {
            int i = 0;
            while (i < sets.length) {
                if (sets[i].isEnabled()) {
                    ruleSets[i] = new RuntimeRuleSetWrapper(sets[i]);
                    this.wrappers.put(sets[i].getName(), ruleSets[i]);
                    new RWLImpl(ruleSets[i]);
                    VRule[] rs = this.getRules(sets[i], rules);
                    ArrayList<RuntimeRuleWrapper> lc = new ArrayList<RuntimeRuleWrapper>();
                    int j = 0;
                    while (j < rs.length) {
                        if (rs[j].isEnabled()) {
                            RuntimeRuleWrapper r = new RuntimeRuleWrapper(rs[j]);
                            this.wrappers.put(rs[j].getName(), r);
                            r.setManager(rulesManager);
                            new RWLImpl(r);
                            lc.add(r);
                        }
                        ++j;
                    }
                    RuntimeItemWrapper[] cw = lc.toArray(new RuntimeItemWrapper[0]);
                    ruleSets[i].children = cw;
                }
                ++i;
            }
        }
        this.provider.ruleSets = ruleSets;
        this.changeControl(INITIAL_COMMANDS);
    }

    public String[] getCommands() {
        return INITIAL_COMMANDS;
    }

    public String getDefaultCommand() {
        return INITIAL_COMMANDS[0];
    }

    private VRuleSet[] getRuleSets(VRule[] rules) {
        HashSet<String> s = new HashSet<String>();
        ArrayList<VRuleSet> l = new ArrayList<VRuleSet>();
        int i = 0;
        while (i < rules.length) {
            VRuleSet set = rules[i].getRuleSet();
            if (!s.contains(set.getName())) {
                s.add(set.getName());
                l.add(set);
            }
            ++i;
        }
        return l.toArray(new VRuleSet[0]);
    }

    private VRule[] getRules(VRuleSet set, VRule[] rules) {
        ArrayList<VRule> l = new ArrayList<VRule>();
        int i = 0;
        while (i < rules.length) {
            if (set == rules[i].getRuleSet()) {
                l.add(rules[i]);
            }
            ++i;
        }
        return l.toArray(new VRule[0]);
    }

    public void changeControl(String[] commands) {
        this.commandBar.setCommands(commands);
        this.commandBar.setDefaultCommand(commands[0]);
        this.commandBar.update();
        if (this.commandBar.getControl() != null && !this.commandBar.getControl().isDisposed()) {
            this.commandBar.getControl().pack();
            this.commandBar.getControl().getParent().layout();
        }
    }

    public RuntimeItemWrapper findWrapper(String id) {
        return this.wrappers.get(id);
    }

    public void action(String command) {
        this.stopEditing();
        if (COMMAND_RUN_ALL.equals(command)) {
            this.clearStatus();
            if (this.task != null) {
                this.task.removeTaskListener(this.listener);
            }
            this.task = this.getRulesManager().createTask(this.vobject);
            this.task.addTaskListener(this.listener);
            this.task.start();
        } else if (COMMAND_RUN_SELECTED.equals(command)) {
            this.clearStatus();
            VRule[] rs = this.getSelectedRules();
            if (rs == null) {
                return;
            }
            if (this.task != null) {
                this.task.removeTaskListener(this.listener);
            }
            this.task = this.getRulesManager().createTask(this.vobject, rs);
            this.task.addTaskListener(this.listener);
            this.task.start();
        } else if (COMMAND_CLOSE.equals(command)) {
            if (this.task != null) {
                this.task.removeTaskListener(this.listener);
                this.task.stop();
                this.task = null;
            }
            this.setCode(0);
            this.dispose();
        } else if (COMMAND_STOP.equals(command)) {
            if (this.task != null) {
                this.task.stop();
            }
        } else if (COMMAND_PAUSE.equals(command)) {
            if (this.task != null) {
                this.task.pause();
            }
        } else if (COMMAND_RESUME.equals(command)) {
            if (this.task != null) {
                this.task.start();
            }
        } else if (HELP.equals(command)) {
            super.action(command);
        }
    }

    int getErrorCountLimit() {
        XModelObject o = PreferenceModelUtilities.getPreferenceModel().getByPath(VerificationPreferencePage.PREFERENCES[0]);
        if (o == null) {
            return -1;
        }
        String s = o.getAttributeValue(VerificationPreferencePage.ATTR_ERRORS_NUMBER_LIMIT);
        int limit = -1;
        if (!"unlimited".equals(s) && s != null && s.length() > 0) {
            try {
                limit = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                XStudioVerificationPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return limit;
    }

    public void limitReached() {
        if (this.limitLock) {
            return;
        }
        this.limitLock = true;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ServiceDialog d = VerifyWizardView.this.model.getService();
                d.showDialog(VerificationUIMessages.WARNING, NLS.bind((String)VerificationUIMessages.LIMIT_OF_REPORTED_ERRORS_IS_REACHED, (Object)("" + VerifyWizardView.this.getErrorCountLimit())), new String[]{VerificationUIMessages.OK}, null, 2);
                VerifyWizardView.this.limitLock = false;
                VerifyWizardView.this.task.stop();
            }
        });
    }

    private VRule[] getSelectedRules() {
        if (this.treeViewer == null) {
            return null;
        }
        ArrayList<VRule> list = new ArrayList<VRule>();
        HashSet<String> set = new HashSet<String>();
        TreeItem[] is = this.treeViewer.getTree().getSelection();
        if (is == null || is.length == 0) {
            return null;
        }
        int i = 0;
        while (i < is.length) {
            RuntimeItemWrapper w = (RuntimeItemWrapper)is[i].getData();
            if (w != null) {
                VRule[] rs = w.getRules();
                int j = 0;
                while (j < rs.length) {
                    if (!set.contains(rs[j].getName())) {
                        set.add(rs[j].getName());
                        list.add(rs[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new VRule[0]);
    }

    private void clearStatus() {
        RuntimeRuleSetWrapper[] ruleSets = this.provider.getRuleSets();
        int i = 0;
        while (i < ruleSets.length) {
            ruleSets[i].setStatus(0);
            RuntimeItemWrapper[] cs = ruleSets[i].children;
            int j = 0;
            while (j < cs.length) {
                cs[j].setStatus(0);
                ++j;
            }
            ++i;
        }
    }

    class RWLImpl
    implements RuntimeItemWrapperListener {
        RuntimeItemWrapper wrapper;

        public RWLImpl(RuntimeItemWrapper wrapper) {
            this.wrapper = wrapper;
            wrapper.setListener(this);
        }

        @Override
        public void statusChanged() {
            if (VerifyWizardView.this.treeViewer != null) {
                VerifyWizardView.this.treeViewer.refresh((Object)this.wrapper);
            }
        }
    }
}

