/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.RegularObjectImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.verification.vrules.VHelper;
import org.jboss.tools.common.verification.vrules.VManager;
import org.jboss.tools.common.verification.vrules.VMessageFormat;
import org.jboss.tools.common.verification.vrules.VModel;
import org.jboss.tools.common.verification.vrules.VRuleSet;
import org.jboss.tools.common.verification.vrules.impl.VManagerImpl;
import org.jboss.tools.common.verification.vrules.layer.VModelFactory;
import org.jboss.tools.common.verification.vrules.layer.VModelImpl;
import org.jboss.tools.common.verification.vrules.model.VRuleSetModel;

public class VManagerModel
extends RegularObjectImpl
implements PropertyChangeListener {
    private static final long serialVersionUID = 2133677518200661058L;
    protected VManagerImpl manager;
    protected boolean developer = false;
    static Map<String, Object> bundles = new HashMap<String, Object>();

    public VManager getManager() {
        if (this.manager == null) {
            this.init();
        }
        return this.manager;
    }

    public void init() {
        this.manager = new VManagerImpl();
        this.manager.setModel(new VModelImpl(this.getModel()));
        VHelper.setManager(this);
        this.manager.setMessageFormat(new VMessageFormat(this.getBundle(this.getAttributeValue("bundle")).getString(this.getAttributeValue("format id"))));
        this.manager.setRuleSets(this.getRuleSets());
        String s = this.getAttributeValue("minimum significance");
        try {
            if (s != null && s.length() > 0) {
                this.manager.setMinSignificance(Integer.parseInt(s));
            }
        }
        catch (NumberFormatException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        this.developer = "developer".equals(this.getAttributeValue("mode"));
        this.manager.addPropertyChangeListener(this);
    }

    private ResourceBundle getBundle(String baseName) {
        if (baseName == null || baseName.length() == 0) {
            return null;
        }
        if ("null".equals(bundles.get(baseName))) {
            return null;
        }
        ResourceBundle bundle = (ResourceBundle)bundles.get(baseName);
        if (bundle != null) {
            return bundle;
        }
        bundle = ResourceBundle.getBundle(baseName);
        Object bo = bundle == null ? "null" : bundle;
        bundles.put(baseName, bo);
        return bundle;
    }

    private VRuleSet[] getRuleSets() {
        XModelObject[] c = this.getChildren();
        VRuleSet[] ruleSets = new VRuleSet[c.length];
        int i = 0;
        while (i < c.length) {
            ruleSets[i] = ((VRuleSetModel)c[i]).getRuleSet();
            ++i;
        }
        return ruleSets;
    }

    protected void loadChildren() {
        if (this.getParent() != null) {
            VHelper.setManager(this);
        }
        if (this.manager == null && this.getParent() != null) {
            this.init();
        }
    }

    public boolean addChild(XModelObject child) {
        boolean res = super.addChild(child);
        if (res && this.manager != null) {
            VRuleSet ruleSet = ((VRuleSetModel)child).getRuleSet();
            this.manager.loadRuleSet(ruleSet);
        }
        return res;
    }

    public void removeChild(XModelObject child) {
        super.removeChild(child);
        if (this.manager != null) {
            VRuleSet ruleSet = ((VRuleSetModel)child).getRuleSet();
            this.manager.unloadRuleSet(ruleSet);
            VModel vmodel = VModelFactory.getModel(this.getModel());
            ((VModelImpl)vmodel).removeRuleSetActionList(ruleSet);
        }
    }

    public String setAttributeValue(String name, String value) {
        String result = super.setAttributeValue(name, value);
        if (this.manager != null) {
            if ("mode".equals(name)) {
                this.developer = "developer".equals(this.getAttributeValue("mode"));
            } else if ("minimum significance".equals(name)) {
                try {
                    if (result != null && result.length() > 0) {
                        this.manager.setMinSignificance(Integer.parseInt(result));
                    }
                }
                catch (NumberFormatException e) {
                    ModelPlugin.getPluginLog().logError((Throwable)e);
                }
            }
        }
        return result;
    }

    protected Comparator<XModelObject> createComparator() {
        return super.createComparator();
    }

    public boolean isObjectEditable() {
        return this.developer && super.isObjectEditable();
    }

    public boolean isAttributeEditable(String name) {
        return "mode".equals(name) || "minimum significance".equals(name) || super.isAttributeEditable(name);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        String value = "" + evt.getNewValue();
        if ("minSignificance".equals(name) && !value.equals(this.getAttributeValue("minimum significance"))) {
            this.setAttributeValue("minimum significance", value);
            this.setModified(true);
        }
    }
}

