/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.RegularObjectImpl;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.jboss.tools.common.verification.vrules.VEntity;
import org.jboss.tools.common.verification.vrules.VModel;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VRuleSet;
import org.jboss.tools.common.verification.vrules.impl.VRuleSetImpl;
import org.jboss.tools.common.verification.vrules.layer.VModelFactory;
import org.jboss.tools.common.verification.vrules.layer.VModelImpl;
import org.jboss.tools.common.verification.vrules.model.VRuleModel;
import org.jboss.tools.common.verification.vrules.plugin.VerificationPlugin;

public class VRuleSetModel
extends RegularObjectImpl
implements PropertyChangeListener {
    private static final long serialVersionUID = 2133689216972164607L;
    protected VRuleSetImpl ruleSet;
    protected boolean installed = false;
    static Map<String, Object> bundles = new HashMap<String, Object>();
    static Object NULL = new Object();

    public VRuleSet getRuleSet() {
        return this.getRuleSet(null);
    }

    public VRuleSet getRuleSet(VRuleSet parent) {
        if (this.ruleSet == null) {
            this.ruleSet = new VRuleSetImpl();
            this.ruleSet.setManagerKey(this.getModel());
            this.ruleSet.setName(this.getAttributeValue("name"));
            this.ruleSet.setDescription(this.getAttributeValue("description"));
            this.ruleSet.setEnabled(Boolean.valueOf(this.getAttributeValue("enabled")));
            String defaultEnabled = this.get("default-enabled");
            if ("false".equals(defaultEnabled)) {
                this.ruleSet.setDefaultEnabled(false);
            }
            this.ruleSet.setURL(this.getAttributeValue("url"));
            this.ruleSet.setVendor(this.getAttributeValue("vendor"));
            this.ruleSet.setVersion(this.getAttributeValue("version"));
            this.ruleSet.setResourceBundle(VRuleSetModel.getBundle(this.getAttributeValue("bundle")));
            this.ruleSet.setRules(this.getRules());
            this.ruleSet.setRuleSets(this.getRuleSets());
            this.installed = Boolean.valueOf(this.getAttributeValue("installed"));
            this.ruleSet.addPropertyChangeListener(this);
        }
        if (parent != null && this.ruleSet.getParentRuleSet() == null) {
            this.ruleSet.setParentRuleSet(parent);
        }
        return this.ruleSet;
    }

    private VRule[] getRules() {
        XModelObject[] c = this.getChildren("VRule");
        VRule[] rules = new VRule[c.length];
        int i = 0;
        while (i < c.length) {
            rules[i] = ((VRuleModel)c[i]).getRule(this.ruleSet);
            ++i;
        }
        return rules;
    }

    private VRuleSet[] getRuleSets() {
        XModelObject[] c = this.getChildren("VRuleSet");
        VRuleSet ruleSet = this.getRuleSet();
        VRuleSet[] ruleSets = new VRuleSet[c.length];
        int i = 0;
        while (i < c.length) {
            ruleSets[i] = ((VRuleSetModel)c[i]).getRuleSet(ruleSet);
            ++i;
        }
        return ruleSets;
    }

    private static ResourceBundle getBundle(String baseName) {
        if (baseName == null || baseName.length() == 0) {
            return null;
        }
        if (bundles.get(baseName) == NULL) {
            return null;
        }
        ResourceBundle resourceBundle = (ResourceBundle)bundles.get(baseName);
        if (resourceBundle != null) {
            return resourceBundle;
        }
        String bundleLoaderClassName = String.valueOf(baseName.substring(0, baseName.lastIndexOf(46) + 1)) + "BundleLoader";
        Class c = ModelFeatureFactory.getInstance().getFeatureClass(bundleLoaderClassName);
        if (c != null) {
            try {
                ResourceBundle b = ResourceBundle.getBundle(baseName, Locale.getDefault(), c.getClassLoader());
                if (b != null) {
                    bundles.put(baseName, b);
                    return b;
                }
            }
            catch (RuntimeException runtimeException) {}
        }
        bundles.put(baseName, NULL);
        if (VerificationPlugin.isDebugEnabled()) {
            VerificationPlugin.getPluginLog().logInfo("Resource not found: " + baseName + " by org.jboss.tools.common.verification.vrules.model.VRuleSetModel:getBundle()");
        }
        return null;
    }

    public void set(String name, String value) {
        super.set(name, value);
        if (this.ruleSet != null && "default-enabled".equals(name) && "false".equals(value)) {
            this.ruleSet.setDefaultEnabled(false);
        }
    }

    public String setAttributeValue(String name, String value) {
        String result = super.setAttributeValue(name, value);
        if (this.ruleSet != null) {
            if ("enabled".equals(name)) {
                this.ruleSet.setEnabled(Boolean.valueOf(result));
            } else if ("name".equals(name)) {
                String oldName = this.ruleSet.getName();
                this.ruleSet.setName(result);
                VModel vmodel = VModelFactory.getModel(this.getModel());
                ((VModelImpl)vmodel).updateRuleSetActionList(this.ruleSet, oldName);
            } else if ("installed".equals(name)) {
                this.installed = Boolean.valueOf(result);
            } else if ("bundle".equals(name)) {
                this.ruleSet.setResourceBundle(VRuleSetModel.getBundle(result));
            }
        }
        return result;
    }

    public boolean addChild(XModelObject child) {
        boolean res = super.addChild(child);
        if (res && this.ruleSet != null) {
            this.ruleSet.setRules(this.getRules());
            this.ruleSet.setRuleSets(this.getRuleSets());
            if (child instanceof VRuleSetModel) {
                return true;
            }
            VRule rule = ((VRuleModel)child).getRule(this.ruleSet);
            VEntity[] entities = rule.getEntities();
            int i = 0;
            while (i < entities.length) {
                if (entities[i] != null) {
                    entities[i].addRule(rule);
                }
                ++i;
            }
        }
        return res;
    }

    public void removeChild(XModelObject child) {
        super.removeChild(child);
        if (this.ruleSet != null) {
            this.ruleSet.setRules(this.getRules());
            VRule rule = ((VRuleModel)child).getRule(this.ruleSet);
            VEntity[] entities = rule.getEntities();
            int i = 0;
            while (i < entities.length) {
                if (entities[i] != null) {
                    entities[i].removeRule(rule);
                }
                ++i;
            }
            VModel vmodel = VModelFactory.getModel(child.getModel());
            ((VModelImpl)vmodel).removeRuleAction(rule);
        }
    }

    protected Comparator<XModelObject> createComparator() {
        return super.createComparator();
    }

    public boolean isObjectEditable() {
        return !this.installed && super.isObjectEditable();
    }

    public boolean isAttributeEditable(String name) {
        return "enabled".equals(name) || super.isAttributeEditable(name);
    }

    public String getPathPart() {
        return this.getAttributeValue("name");
    }

    public String getPresentationString() {
        return this.getAttributeValue("name");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        String value = "" + evt.getNewValue();
        if ("enabled".equals(name) && !value.equals(this.getAttributeValue(name))) {
            this.setAttributeValue(name, value);
            this.setModified(true);
        }
    }
}

