/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.engines.impl.EnginesLoader;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.verification.vrules.model.RuleSetResourceLoader;
import org.jboss.tools.common.verification.vrules.plugin.VerificationPlugin;
import org.w3c.dom.Element;

public class VRuleSetsLoader
extends EnginesLoader {
    static int i = 0;

    public VRuleSetsLoader() {
        util.setup(null, false);
    }

    public void load(XModelObject object) {
        if ("true".equals(object.getModel().getProperties().getProperty("initialModel"))) {
            return;
        }
        super.load(object);
        HashSet<String> installed = new HashSet<String>();
        Set resources = RuleSetResourceLoader.getResources("org.jboss.tools.common.verification.rules");
        ArrayList<URL> l = new ArrayList<URL>();
        for (URL url : resources) {
            try {
                if (url != null) {
                    url = FileLocator.resolve((URL)url);
                }
                if (url == null) continue;
                l.add(url);
            }
            catch (IOException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        Iterator it = l.iterator();
        while (it.hasNext()) {
            try {
                URL url;
                url = (URL)it.next();
                InputStream is = url.openConnection().getInputStream();
                Element element = XMLUtil.getElement((InputStream)is);
                if (element == null) continue;
                XModelObject copy = object.copy(0);
                this.util().load(element, copy);
                XModelObject[] nc = copy.getChildren();
                int j = 0;
                while (j < nc.length) {
                    XModelObject c = object.getChildByPath(nc[j].getPathPart());
                    if (c == null) {
                        c = nc[j].copy();
                        object.addChild(c);
                        this.mergeRules(c, c);
                    } else {
                        this.mergeRules(c, nc[j]);
                    }
                    c.setAttributeValue("installed", "true");
                    installed.add(c.getPathPart());
                    ++j;
                }
            }
            catch (XModelException e) {
                VerificationPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (IOException e) {
                VerificationPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        XModelObject[] ch = object.getChildren();
        int i = 0;
        while (i < ch.length) {
            String ins = ch[i].getAttributeValue("installed");
            if ("true".equals(ins) && !installed.contains(ch[i].getPathPart())) {
                ch[i].removeFromParent();
            }
            ++i;
        }
    }

    protected void mergeRules(XModelObject object, XModelObject update) throws XModelException {
        XModelObject c;
        XAttribute[] as = object.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String nv;
            String ov;
            String n = as[i].getName();
            if ("enabled".equals(n)) {
                String nv2 = update.getAttributeValue(n);
                object.set("default-enabled", nv2);
            }
            if (!("enabled".equals(n) || "installed".equals(n) || (ov = object.getAttributeValue(n)).equals(nv = update.getAttributeValue(n)))) {
                object.getModel().changeObjectAttribute(object, n, nv);
            }
            ++i;
        }
        XModelObject[] cs = update.getChildren();
        int i2 = 0;
        while (i2 < cs.length) {
            c = object.getChildByPath(cs[i2].getPathPart());
            if (c == null) {
                object.addChild(cs[i2].copy());
            } else {
                this.mergeRules(c, cs[i2]);
            }
            ++i2;
        }
        cs = ((XModelObjectImpl)object).getChildrenForSave();
        i2 = 0;
        while (i2 < cs.length) {
            c = update.getChildByPath(cs[i2].getPathPart());
            if (c == null) {
                cs[i2].removeFromParent();
            }
            ++i2;
        }
    }

    public boolean save(XModelObject object) {
        if (object.getModel() != PreferenceModelUtilities.getPreferenceModel()) {
            return true;
        }
        return super.save(object);
    }

    protected String fileName(XModelObject object) {
        return ".rule-sets.xml";
    }
}

