/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.discovery.core.internal.connectors;

import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.core.model.ValidationException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.foundation.core.expressions.ExpressionResolutionException;
import org.jboss.tools.foundation.core.expressions.ExpressionResolver;
import org.jboss.tools.foundation.core.expressions.IVariableResolver;
import org.jboss.tools.foundation.core.properties.IPropertiesProvider;
import org.jboss.tools.foundation.core.properties.PropertiesHelper;

public class ExpressionBasedDiscoveryConnector
extends DiscoveryConnector {
    public void validate() throws ValidationException {
        try {
            IPropertiesProvider propertiesProvider = PropertiesHelper.getPropertiesProvider();
            RemotePropertiesResolver variableResolver = new RemotePropertiesResolver(propertiesProvider);
            this.siteUrl = new ExpressionResolver((IVariableResolver)variableResolver).resolve(this.siteUrl);
            super.validate();
        }
        catch (ExpressionResolutionException e) {
            throw new ValidationException(NLS.bind((String)"Resolving expression in URL ''{0}'' failed with error: \"{1}\"", (Object)this.siteUrl, (Object)e.getMessage()));
        }
    }

    static class RemotePropertiesResolver
    implements IVariableResolver {
        private IPropertiesProvider propertiesProvider;

        public RemotePropertiesResolver(IPropertiesProvider propertiesProvider) {
            this.propertiesProvider = propertiesProvider;
        }

        public String resolve(String variable, String defaultValue) {
            ExpressionResolver.SystemPropertiesVariableResolver delegate = new ExpressionResolver.SystemPropertiesVariableResolver();
            String result = delegate.resolve(variable, null);
            if (result == null) {
                result = this.propertiesProvider.getValue(variable, defaultValue);
            }
            return result;
        }
    }
}

