/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.discovery.core.internal.connectors;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryFeedbackJob;
import org.eclipse.mylyn.internal.discovery.ui.InstalledItem;
import org.eclipse.mylyn.internal.discovery.ui.UninstallRequest;
import org.eclipse.mylyn.internal.discovery.ui.wizards.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.statushandlers.StatusManager;
import org.jboss.tools.discovery.core.internal.DiscoveryActivator;
import org.jboss.tools.discovery.core.internal.connectors.DiscoveryUtil;
import org.jboss.tools.discovery.core.internal.connectors.PrepareInstallProfileJob;
import org.jboss.tools.discovery.core.internal.connectors.PrepareUninstallProfileJob;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;

public class JBossDiscoveryUi {
    public static boolean isEarlyAccessEnabled() {
        return DiscoveryActivator.getDefault().getPreferences().getBoolean("enableEarlyAccess", false);
    }

    public static boolean install(Collection<ConnectorDescriptor> descriptors, IRunnableContext context) {
        for (ConnectorDescriptor toInstall : descriptors) {
            if (toInstall.getInstallableUnits() != null && !toInstall.getInstallableUnits().isEmpty()) continue;
            return false;
        }
        try {
            PrepareInstallProfileJob runner = JBossDiscoveryUi.createInstallJob(descriptors);
            if (context != null) {
                context.run(true, true, (IRunnableWithProgress)runner);
            } else {
                runner.run((IProgressMonitor)new NullProgressMonitor());
            }
            new DiscoveryFeedbackJob((List)(descriptors instanceof List ? (List<Object>)descriptors : new ArrayList<ConnectorDescriptor>(descriptors))).schedule();
            JBossDiscoveryUi.recordInstalled(descriptors);
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.jboss.tools.discovery.core", NLS.bind((String)Messages.ConnectorDiscoveryWizard_installProblems, (Object[])new Object[]{e.getCause().getMessage()}), e.getCause());
            StatusManager.getManager().handle((IStatus)status, 7);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static boolean uninstall(final List<ConnectorDescriptor> descriptors, IRunnableContext context, boolean fork) {
        try {
            UninstallRequest request = new UninstallRequest(){

                public boolean select(InstalledItem item) {
                    for (ConnectorDescriptor desc : descriptors) {
                        for (String id : desc.getInstallableUnits()) {
                            if (!id.equals(desc.getId())) continue;
                            return true;
                        }
                    }
                    return false;
                }
            };
            PrepareUninstallProfileJob runner = new PrepareUninstallProfileJob(descriptors, request);
            context.run(fork, true, (IRunnableWithProgress)runner);
            DiscoveryFeedbackJob discoveryFeedbackJob = new DiscoveryFeedbackJob(descriptors);
            discoveryFeedbackJob.schedule();
            if (!fork) {
                discoveryFeedbackJob.join();
                return discoveryFeedbackJob.getResult().isOK();
            }
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.jboss.tools.discovery.core", NLS.bind((String)Messages.ConnectorDiscoveryWizard_installProblems, (Object[])new Object[]{e.getCause().getMessage()}), e.getCause());
            StatusManager.getManager().handle((IStatus)status, 7);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static PrepareInstallProfileJob createInstallJob(Collection<ConnectorDescriptor> descriptors) {
        return new PrepareInstallProfileJob(descriptors);
    }

    private static void recordInstalled(Collection<ConnectorDescriptor> descriptors) {
        StringBuilder sb = new StringBuilder();
        for (ConnectorDescriptor descriptor : descriptors) {
            UsageEventType eventType = DiscoveryActivator.getDefault().getInstallSoftwareEventType();
            UsageReporter.getInstance().trackEvent(eventType.event(descriptor.getId()));
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(descriptor.getId());
        }
        ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.mylyn.discovery.ui");
        store.putValue("lastInstalled", sb.toString());
        try {
            store.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean isEarlyAccess(ConnectorDescriptor connector) {
        String cert = connector.getCertificationId();
        return cert != null && cert.toLowerCase().contains("earlyaccess");
    }

    public static boolean isInstallableConnector(ConnectorDescriptor connector) {
        return connector.getCertificationId() == null || !connector.getCertificationId().toLowerCase().contains("notavailable");
    }

    public static Collection<ConnectorDescriptor> resolveToConnectors(Collection<String> connectorsId, IRunnableContext context) {
        HashMap<String, ConnectorDescriptor> res = new HashMap<String, ConnectorDescriptor>();
        final ConnectorDiscovery catalog = DiscoveryUtil.createConnectorDiscovery();
        try {
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    catalog.performDiscovery(monitor);
                }
            });
        }
        catch (InterruptedException ex) {
            DiscoveryActivator.getDefault().getLog().log((IStatus)new Status(4, DiscoveryActivator.getDefault().getBundle().getSymbolicName(), ex.getMessage(), (Throwable)ex));
        }
        catch (InvocationTargetException ex) {
            DiscoveryActivator.getDefault().getLog().log((IStatus)new Status(4, DiscoveryActivator.getDefault().getBundle().getSymbolicName(), ex.getMessage(), (Throwable)ex));
        }
        for (ConnectorDescriptor connector : catalog.getConnectors()) {
            if (!connectorsId.contains(connector.getId()) || connector.getInstallableUnits() == null || connector.getInstallableUnits().isEmpty() || !JBossDiscoveryUi.isInstallableConnector(connector)) continue;
            if (JBossDiscoveryUi.isEarlyAccess(connector)) {
                if (!JBossDiscoveryUi.isEarlyAccessEnabled()) continue;
                res.put(connector.getId(), connector);
                continue;
            }
            if (res.containsKey(connector.getId())) continue;
            res.put(connector.getId(), connector);
        }
        if (res.size() != connectorsId.size()) {
            HashSet<String> missingConnectoes = new HashSet<String>(connectorsId);
            missingConnectoes.removeAll(res.keySet());
            DiscoveryActivator.getDefault().getLog().log((IStatus)new Status(4, DiscoveryActivator.getDefault().getBundle().getSymbolicName(), "Could not resolve the following connectorIds to catalog entries: " + ((Object)missingConnectoes).toString()));
        }
        return res.values();
    }

    public static boolean installByIds(Collection<String> connectorIds, IRunnableContext context) {
        Collection<ConnectorDescriptor> connectorsToInstall = JBossDiscoveryUi.resolveToConnectors(connectorIds, context);
        if (connectorsToInstall == null || connectorsToInstall.size() != connectorIds.size()) {
            return false;
        }
        return JBossDiscoveryUi.install(connectorsToInstall, context);
    }

    public static final class PreferenceKeys {
        public static final String ENABLE_EARLY_ACCESS = "enableEarlyAccess";
        private static final boolean ENABLE_EARLY_ACCESS_DEFAULT_VALUE = false;
    }
}

