/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.core.furnace;

import java.util.List;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.furnace.ContainerStatus;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;

public enum FurnaceService {
    INSTANCE;

    private transient Furnace furnace;

    public void setFurnace(Furnace forge) {
        this.furnace = forge;
    }

    public void start() {
        if (this.furnace.getStatus().isStopped()) {
            this.furnace.startAsync();
        }
    }

    public AddonRegistry getAddonRegistry() {
        return this.furnace.getAddonRegistry(new AddonRepository[0]);
    }

    public List<AddonRepository> getRepositories() {
        return this.furnace.getRepositories();
    }

    public void stop() {
        if (this.furnace != null) {
            this.furnace.stop();
            this.furnace = null;
        }
    }

    public void waitUntilContainerIsStarted() throws InterruptedException {
        while (!this.getContainerStatus().isStarted()) {
            Thread.sleep(500L);
        }
    }

    public ContainerStatus getContainerStatus() {
        return this.furnace == null ? ContainerStatus.STOPPED : this.furnace.getStatus();
    }

    public ConverterFactory getConverterFactory() {
        ConverterFactory converterFactory = this.lookup(ConverterFactory.class);
        while (converterFactory == null) {
            try {
                Thread.sleep(100L);
                converterFactory = this.lookup(ConverterFactory.class);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        return converterFactory;
    }

    public <S> Imported<S> lookupImported(Class<S> service) {
        Imported instance = null;
        if (this.furnace != null) {
            instance = this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(service);
        }
        return instance;
    }

    public <S> S lookup(Class<S> service) {
        Imported instance = null;
        if (this.furnace != null) {
            instance = this.furnace.getAddonRegistry(new AddonRepository[0]).getServices(service);
        }
        return (S)(instance == null ? null : instance.get());
    }

    public boolean isFurnaceSet() {
        return this.furnace != null;
    }
}

