/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.core.internal.runtime;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.jboss.tools.forge.core.internal.ForgeCorePlugin;
import org.jboss.tools.forge.core.internal.process.ForgeRuntimeProcess;
import org.jboss.tools.forge.core.io.ForgeHiddenOutputFilter;
import org.jboss.tools.forge.core.io.ForgeOutputListener;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeState;

public abstract class ForgeAbstractRuntime
implements ForgeRuntime {
    private IProcess process = null;
    private ForgeRuntimeState state = ForgeRuntimeState.STOPPED;
    private String version = null;
    private final TerminateListener terminateListener = new TerminateListener();
    private MasterStreamListener masterStreamListener = new MasterStreamListener();
    private CommandResultListener commandResultListener = new CommandResultListener();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private List<ForgeOutputListener> outputListeners = new ArrayList<ForgeOutputListener>();
    private boolean commandResultAvailable = false;
    private String commandResult = null;
    private Object mutex = new Object();
    private String errorMessage = null;

    public IProcess getProcess() {
        return this.process;
    }

    @Override
    public ForgeRuntimeState getState() {
        return this.state;
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.version = this.initializeVersion();
        }
        return this.version;
    }

    private String initializeVersion() {
        String[] candidates;
        String result = "unknown version";
        String location = this.getLocation();
        if (location == null) {
            return result;
        }
        File file = new File(location = String.valueOf(location) + "/modules/org/jboss/forge/shell/api/main");
        if (!file.exists()) {
            return result;
        }
        String[] stringArray = candidates = file.list();
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            int end;
            String candidate = stringArray[n2];
            if (candidate.startsWith("forge-shell-api-") && (end = candidate.indexOf(".jar")) != -1) {
                result = candidate.substring("forge-shell-api-".length(), end);
            }
            ++n2;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void start(IProgressMonitor progressMonitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendCommand(String str) {
        IStreamsProxy streamsProxy;
        String result = null;
        if (this.process != null && !this.process.isTerminated() && (streamsProxy = this.getStreamsProxy()) != null) {
            IStreamMonitor errorStreamMonitor = streamsProxy.getErrorStreamMonitor();
            errorStreamMonitor.removeListener((IStreamListener)this.masterStreamListener);
            IStreamMonitor streamMonitor = streamsProxy.getOutputStreamMonitor();
            if (streamMonitor != null) {
                Object object = this.mutex;
                synchronized (object) {
                    try {
                        streamsProxy.write(String.valueOf(Character.toString('\u001f')) + str + '\n');
                    }
                    catch (IOException e) {
                        ForgeCorePlugin.log(e);
                    }
                    while (!this.commandResultAvailable) {
                        try {
                            this.mutex.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                result = this.commandResult;
                this.commandResult = null;
                this.commandResultAvailable = false;
            }
            errorStreamMonitor.addListener((IStreamListener)this.masterStreamListener);
        }
        return result;
    }

    @Override
    public void sendInput(String str) {
        IStreamsProxy streamProxy;
        if (this.process != null && !this.process.isTerminated() && (streamProxy = this.getStreamsProxy()) != null) {
            try {
                streamProxy.write(str);
            }
            catch (IOException e) {
                ForgeCorePlugin.log(e);
            }
        }
    }

    @Override
    public void stop(IProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        try {
            progressMonitor.beginTask("Stopping Forge", 1);
            this.terminate();
        }
        finally {
            progressMonitor.done();
        }
    }

    private void terminate() {
        try {
            if (this.process != null) {
                IStreamsProxy streamsProxy = this.getStreamsProxy();
                if (streamsProxy != null) {
                    IStreamMonitor errorStreamMonitor;
                    IStreamMonitor outputStreamMonitor = streamsProxy.getOutputStreamMonitor();
                    if (outputStreamMonitor != null) {
                        outputStreamMonitor.removeListener((IStreamListener)this.masterStreamListener);
                    }
                    if ((errorStreamMonitor = streamsProxy.getErrorStreamMonitor()) != null) {
                        errorStreamMonitor.removeListener((IStreamListener)this.masterStreamListener);
                    }
                }
                this.process.terminate();
                ForgeCorePlugin.removeForgeProcess(this.process);
            }
        }
        catch (DebugException e) {
            ForgeCorePlugin.log(e);
        }
    }

    private void setNewState(ForgeRuntimeState newState) {
        ForgeRuntimeState oldState = this.state;
        this.state = newState;
        this.propertyChangeSupport.firePropertyChange("org.jboss.tools.forge.runtime.state", (Object)oldState, (Object)this.state);
    }

    private IStreamsProxy getStreamsProxy() {
        if (this.process instanceof ForgeRuntimeProcess) {
            return ((ForgeRuntimeProcess)this.process).getForgeStreamsProxy();
        }
        return this.process.getStreamsProxy();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addOutputListener(ForgeOutputListener listener) {
        this.outputListeners.add(listener);
    }

    @Override
    public void removeOutputListener(ForgeOutputListener listener) {
        this.outputListeners.remove(listener);
    }

    private class CommandResultListener
    extends ForgeHiddenOutputFilter
    implements IStreamListener {
        private CommandResultListener() {
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.outputAvailable(text);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleFilteredString(String str) {
            if (str.startsWith("RESULT: ")) {
                ForgeAbstractRuntime.this.commandResult = str.substring(8);
                ForgeAbstractRuntime.this.commandResultAvailable = true;
                Object object = ForgeAbstractRuntime.this.mutex;
                synchronized (object) {
                    ForgeAbstractRuntime.this.mutex.notifyAll();
                }
            }
        }
    }

    private class ErrorListener
    implements IStreamListener {
        private IStreamMonitor fMonitor;

        public ErrorListener(IStreamMonitor monitor) {
            this.fMonitor = monitor;
            monitor.addListener((IStreamListener)this);
            this.streamAppended(null, this.fMonitor);
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            if (text == null) {
                return;
            }
            ForgeAbstractRuntime.this.errorMessage = monitor.getContents();
            ForgeCorePlugin.logErrorMessage(ForgeAbstractRuntime.this.errorMessage);
        }
    }

    private class MasterStreamListener
    implements IStreamListener {
        private MasterStreamListener() {
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            for (ForgeOutputListener listener : ForgeAbstractRuntime.this.outputListeners) {
                listener.outputAvailable(text);
            }
        }
    }

    private class StartupListener
    implements IStreamListener {
        private StartupListener() {
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            ForgeAbstractRuntime.this.getStreamsProxy().getOutputStreamMonitor().removeListener((IStreamListener)this);
            ForgeAbstractRuntime.this.setNewState(ForgeRuntimeState.RUNNING);
        }
    }

    private class TerminateListener
    implements IDebugEventSetListener {
        private TerminateListener() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                DebugEvent event = events[i];
                if (event.getSource().equals(ForgeAbstractRuntime.this.process) && event.getKind() == 8) {
                    DebugPlugin.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ForgeAbstractRuntime.this.setNewState(ForgeRuntimeState.STOPPED);
                            ForgeCorePlugin.removeForgeProcess(ForgeAbstractRuntime.this.process);
                            ForgeAbstractRuntime.this.process = null;
                            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)ForgeAbstractRuntime.this.terminateListener);
                        }
                    });
                }
                ++i;
            }
        }
    }
}

