/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.core.io;

import org.jboss.tools.forge.core.io.ForgeOutputListener;

public abstract class ForgeAnsiCommandFilter
implements ForgeOutputListener {
    private ForgeOutputListener target = null;
    private StringBuffer escapeSequence = new StringBuffer();
    private StringBuffer targetBuffer = new StringBuffer();

    public ForgeAnsiCommandFilter(ForgeOutputListener target) {
        this.target = target;
    }

    public abstract void ansiCommandAvailable(String var1);

    @Override
    public void outputAvailable(String output) {
        int i = 0;
        while (i < output.length()) {
            char c = output.charAt(i);
            if (c == '\u001b') {
                if (this.escapeSequence.length() == 0) {
                    if (this.targetBuffer.length() > 0) {
                        this.target.outputAvailable(this.targetBuffer.toString());
                        this.targetBuffer.setLength(0);
                    }
                    this.escapeSequence.append(c);
                }
            } else if (c == '[') {
                if (this.escapeSequence.length() == 1) {
                    this.escapeSequence.append(c);
                } else {
                    this.targetBuffer.append(c);
                }
            } else if (this.escapeSequence.length() > 1) {
                this.escapeSequence.append(c);
                if (this.isAnsiEnd(c)) {
                    this.ansiCommandAvailable(this.escapeSequence.toString());
                    this.escapeSequence.setLength(0);
                }
            } else {
                this.targetBuffer.append(c);
            }
            ++i;
        }
        if (this.targetBuffer.length() > 0) {
            this.target.outputAvailable(this.targetBuffer.toString());
            this.targetBuffer.setLength(0);
        }
    }

    private boolean isAnsiEnd(char c) {
        return c == 'G' || c == 'K' || c == 'm' || c == 'H' || c == 'J';
    }
}

