/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects;

import java.util.Optional;
import java.util.Set;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.projects.stacks.Stack;
import org.jboss.forge.addon.projects.stacks.StackBuilder;
import org.jboss.forge.addon.projects.stacks.StackFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.furnace.util.Sets;

public interface Project
extends Faceted<ProjectFacet> {
    public Object getAttribute(Object var1);

    public void setAttribute(Object var1, Object var2);

    public void removeAttribute(Object var1);

    @Deprecated
    default public DirectoryResource getRootDirectory() {
        Resource<?> root = this.getRoot();
        if (root instanceof DirectoryResource) {
            return (DirectoryResource)root;
        }
        throw new IllegalStateException("Project root [" + root + "] is not an instance of DirectoryResource");
    }

    public Resource<?> getRoot();

    default public Optional<Stack> getStack() {
        Optional<Stack> result;
        Set facets = Sets.toSet((Iterable)this.getFacets(StackFacet.class));
        int size = facets.size();
        if (size == 0) {
            result = Optional.empty();
        } else if (size == 1) {
            result = Optional.of(((StackFacet)facets.iterator().next()).getStack());
        } else {
            StackBuilder builder = StackBuilder.stack("Project Stack");
            for (StackFacet facet : facets) {
                Stack stack = facet.getStack();
                builder.includes(stack);
            }
            result = Optional.of(builder);
        }
        return result;
    }
}

