/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.stacks;

import java.util.HashSet;
import java.util.Set;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.projects.stacks.Stack;
import org.jboss.forge.furnace.util.Assert;

public class StackBuilder
implements Stack {
    private final String name;
    private Set<Class<? extends ProjectFacet>> includedFacets = new HashSet<Class<? extends ProjectFacet>>();
    private Set<Class<? extends ProjectFacet>> excludedFacets = new HashSet<Class<? extends ProjectFacet>>();

    private StackBuilder(String name) {
        Assert.notNull((Object)name, (String)"Name cannot be null");
        this.name = name;
    }

    public static StackBuilder stack(String name) {
        return new StackBuilder(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public StackBuilder includes(Class<? extends ProjectFacet> facet) {
        this.includedFacets.add(facet);
        return this;
    }

    public StackBuilder includes(Stack stack) {
        this.includedFacets.addAll(stack.getIncludedFacets());
        this.excludedFacets.addAll(stack.getExcludedFacets());
        return this;
    }

    public StackBuilder excludes(Stack stack) {
        this.excludedFacets.addAll(stack.getIncludedFacets());
        this.excludedFacets.addAll(stack.getExcludedFacets());
        return this;
    }

    public StackBuilder excludes(Class<? extends ProjectFacet> facet) {
        this.excludedFacets.add(facet);
        return this;
    }

    @Override
    public Set<Class<? extends ProjectFacet>> getIncludedFacets() {
        return this.includedFacets;
    }

    @Override
    public Set<Class<? extends ProjectFacet>> getExcludedFacets() {
        return this.excludedFacets;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StackBuilder other = (StackBuilder)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

