/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.stacks;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.projects.stacks.StackFacet;
import org.jboss.forge.addon.projects.stacks.annotations.StackConstraint;
import org.jboss.forge.addon.projects.stacks.annotations.StackConstraints;
import org.jboss.forge.furnace.util.Annotations;

public abstract class StackInspector {
    public static boolean isConstraintSatisfied(Project project, Set<Class<ProjectFacet>> requiredFacets) {
        boolean constraintsSatisfied = true;
        Iterable stackFacets = project.getFacets(StackFacet.class);
        block0: for (StackFacet stackFacet : stackFacets) {
            for (Class<ProjectFacet> type : requiredFacets) {
                if (stackFacet.getStack().supports(type)) continue;
                constraintsSatisfied = false;
                break block0;
            }
        }
        return constraintsSatisfied;
    }

    static <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> boolean hasCircularConstraints(Class<?> inspectedType) {
        Set<Class<FACETTYPE>> allRelatedFacets = StackInspector.getAllRelatedFacets(inspectedType);
        for (Class<FACETTYPE> requirement : allRelatedFacets) {
            for (Class<FACETTYPE> subrequirement : StackInspector.getAllRelatedFacets(requirement)) {
                if (!subrequirement.isAssignableFrom(requirement)) continue;
                return true;
            }
        }
        return false;
    }

    private static <FACETTYPE extends Facet<?>> Set<Class<FACETTYPE>> getRelatedFacets(Class<?> inspectedType) {
        LinkedHashSet<Class<FACETTYPE>> result = new LinkedHashSet<Class<FACETTYPE>>();
        if (Annotations.isAnnotationPresent(inspectedType, StackConstraints.class)) {
            StackConstraints constraints = (StackConstraints)Annotations.getAnnotation(inspectedType, StackConstraints.class);
            for (StackConstraint constraint : constraints.value()) {
                for (Class<? extends ProjectFacet> facetType : constraint.value()) {
                    if (!Facet.class.isAssignableFrom(facetType) || facetType.isAssignableFrom(inspectedType)) continue;
                    result.add(facetType);
                }
            }
        }
        if (Annotations.isAnnotationPresent(inspectedType, StackConstraint.class)) {
            StackConstraint constraint = (StackConstraint)Annotations.getAnnotation(inspectedType, StackConstraint.class);
            for (Class<? extends ProjectFacet> facetType : constraint.value()) {
                if (!Facet.class.isAssignableFrom(facetType) || facetType.isAssignableFrom(inspectedType)) continue;
                result.add(facetType);
            }
        }
        return result;
    }

    public static <FACETTYPE extends Facet<?>> Set<Class<FACETTYPE>> getAllRelatedFacets(Class<?> inspectedType) {
        LinkedHashSet<Class<FACETTYPE>> seen = new LinkedHashSet<Class<FACETTYPE>>();
        return StackInspector.getAllRelatedFacets(seen, inspectedType);
    }

    private static <FACETTYPE extends Facet<?>> Set<Class<FACETTYPE>> getAllRelatedFacets(Set<Class<FACETTYPE>> seen, Class<?> inspectedType) {
        LinkedHashSet<Class<FACETTYPE>> result = new LinkedHashSet<Class<FACETTYPE>>();
        Set<Class<FACETTYPE>> related = StackInspector.getRelatedFacets(inspectedType);
        for (Class<FACETTYPE> relatedType : related) {
            if (seen.contains(relatedType)) continue;
            seen.add(relatedType);
            result.addAll(StackInspector.getAllRelatedFacets(seen, relatedType));
        }
        result.addAll(related);
        return result;
    }
}

