/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.result;

import java.util.List;
import java.util.Optional;
import org.jboss.forge.addon.ui.result.CompositeResult;
import org.jboss.forge.addon.ui.result.Failed;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.Strings;

abstract class CompositeResultImpl
implements CompositeResult {
    private final List<Result> results;
    private final Object entity;

    CompositeResultImpl(List<Result> results, Object entity) {
        Assert.notNull(results, (String)"Result list cannot be null");
        this.results = results;
        this.entity = entity;
    }

    @Override
    public List<Result> getResults() {
        return this.results;
    }

    @Override
    public Optional<Object> getEntity() {
        return Optional.ofNullable(this.entity);
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        for (Result result : this.results) {
            if (Strings.isNullOrEmpty((String)result.getMessage())) continue;
            if (sb.length() > 0) {
                sb.append(System.lineSeparator());
            }
            sb.append(result instanceof Failed ? "***ERROR*** " : "***SUCCESS*** ").append(result.getMessage());
        }
        return sb.toString();
    }

    public static CompositeResult from(List<Result> results, Object entity) {
        boolean failed = false;
        Throwable throwable = null;
        for (Result result : results) {
            if (!(result instanceof Failed)) continue;
            failed = true;
            throwable = ((Failed)result).getException();
            break;
        }
        if (failed) {
            return new CompositeResultFailed(results, throwable, entity);
        }
        return new CompositeResultSuccess(results, entity);
    }

    public static CompositeResult from(List<Result> results) {
        return CompositeResultImpl.from(results, null);
    }

    private static class CompositeResultSuccess
    extends CompositeResultImpl
    implements Result {
        public CompositeResultSuccess(List<Result> results, Object entity) {
            super(results, entity);
        }
    }

    private static class CompositeResultFailed
    extends CompositeResultImpl
    implements Result,
    Failed {
        private final Throwable exception;

        public CompositeResultFailed(List<Result> results, Throwable e, Object entity) {
            super(results, entity);
            this.exception = e;
        }

        @Override
        public Throwable getException() {
            return this.exception;
        }
    }
}

