/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.result;

import java.util.List;
import java.util.Optional;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.result.CompositeResult;
import org.jboss.forge.addon.ui.result.CompositeResultImpl;
import org.jboss.forge.addon.ui.result.Failed;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.furnace.util.Lists;

public final class Results {
    public static final Result success() {
        return Results.success(null);
    }

    public static final Result success(String message) {
        return new SuccessfulResult(message);
    }

    public static final Result success(String message, Object entity) {
        return new SuccessfulResult(message, entity);
    }

    public static final Failed fail() {
        return Results.fail(null);
    }

    public static final Failed fail(String message) {
        return new FailedResult(message);
    }

    public static final Failed fail(String message, Throwable e) {
        return new FailedResult(message, e);
    }

    public static final Failed fail(String message, Throwable e, Object entity) {
        return new FailedResult(message, e, entity);
    }

    public static final NavigationResult navigateTo(Class<? extends UICommand> next) {
        if (next == null) {
            return null;
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        builder.add(next);
        return builder.build();
    }

    public static final NavigationResult navigateTo(Class<? extends UICommand>[] next) {
        if (next == null) {
            return null;
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        for (Class<? extends UICommand> type : next) {
            builder.add(type);
        }
        return builder.build();
    }

    public static final NavigationResult navigateTo(Class<? extends UICommand> next, Class<? extends UICommand> ... additional) {
        if (next == null) {
            return null;
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        builder.add(next);
        for (Class<? extends UICommand> type : additional) {
            builder.add(type);
        }
        return builder.build();
    }

    public static NavigationResultBuilder navigationBuilder() {
        NavigationResultBuilder builder = NavigationResultBuilder.create();
        return builder;
    }

    public static CompositeResult aggregate(Iterable<Result> results) {
        List resultList = Lists.toList(results);
        return CompositeResultImpl.from(resultList);
    }

    public static CompositeResult aggregate(Iterable<Result> results, Object entity) {
        List resultList = Lists.toList(results);
        return CompositeResultImpl.from(resultList, entity);
    }

    private static class FailedResult
    implements Result,
    Failed {
        private final String message;
        private final Object entity;
        private final Throwable e;

        FailedResult(String message) {
            this.message = message;
            this.e = null;
            this.entity = null;
        }

        FailedResult(String message, Throwable e) {
            this.message = message;
            this.e = e;
            this.entity = null;
        }

        FailedResult(String message, Throwable e, Object entity) {
            this.message = message;
            this.e = e;
            this.entity = entity;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public Throwable getException() {
            return this.e;
        }

        @Override
        public Optional<Object> getEntity() {
            return Optional.ofNullable(this.entity);
        }

        public String toString() {
            return "Failed [" + this.message + "]";
        }
    }

    private static class SuccessfulResult
    implements Result {
        private final String message;
        private final Object entity;

        SuccessfulResult(String message) {
            this.message = message;
            this.entity = null;
        }

        SuccessfulResult(String message, Object entity) {
            this.message = message;
            this.entity = entity;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public Optional<Object> getEntity() {
            return Optional.ofNullable(this.entity);
        }

        public String toString() {
            return "Success [" + this.message + "]";
        }
    }
}

