/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.forge.ui.notifications.NotificationDialog;
import org.jboss.tools.forge.ui.notifications.NotificationType;
import org.osgi.framework.BundleContext;

public class ForgeUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.forge.ui";
    private static ForgeUIPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ForgeUIPlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable t) {
        ForgeUIPlugin.getDefault().getLog().log(ForgeUIPlugin.newErrorStatus("Error logged from Forge Plugin: ", t));
    }

    private static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, 1, message, exception);
    }

    public static ImageDescriptor getForgeLogo() {
        return ForgeUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/page.gif");
    }

    public static ImageDescriptor getForgeIcon() {
        return ForgeUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/icon.png");
    }

    public static void displayMessage(final String title, final String message, final NotificationType type) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                NotificationDialog.notify((String)title, (String)message, (NotificationType)type);
            }
        });
    }
}

