/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.forge.core.furnace.FurnaceRuntime;
import org.jboss.tools.forge.core.preferences.ForgeCorePreferences;
import org.jboss.tools.forge.core.runtime.ForgeRuntime;
import org.jboss.tools.forge.core.runtime.ForgeRuntimeState;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.ext.dialog.UICommandListDialog;
import org.jboss.tools.forge.ui.internal.part.ForgeConsoleView;
import org.jboss.tools.forge.ui.util.ForgeHelper;

public class ForgeCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        this.openWizardDialog(window);
        return null;
    }

    public void openWizardDialog(final IWorkbenchWindow window) {
        ForgeRuntime runtime = ForgeCorePreferences.INSTANCE.getDefaultRuntime();
        if (runtime != FurnaceRuntime.INSTANCE) {
            this.startForgeRuntime(runtime);
        } else {
            try {
                ForgeConsoleView forgeConsoleView = ForgeHelper.findForgeConsoleView();
                if (forgeConsoleView != null && forgeConsoleView.isShowing()) {
                    ForgeHelper.showRuntime((ForgeRuntime)FurnaceRuntime.INSTANCE);
                }
                if (this.saveCurrentEditor(window)) {
                    if (!ForgeRuntimeState.RUNNING.equals((Object)FurnaceRuntime.INSTANCE.getState())) {
                        Job job = ForgeHelper.createStartRuntimeJob((ForgeRuntime)FurnaceRuntime.INSTANCE);
                        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent event) {
                                Display.getDefault().asyncExec(() -> {
                                    int n = new UICommandListDialog(window).open();
                                });
                            }
                        });
                        job.schedule();
                    } else {
                        new UICommandListDialog(window).open();
                    }
                }
            }
            catch (Exception e) {
                ForgeUIPlugin.log(e);
            }
        }
    }

    private boolean saveCurrentEditor(IWorkbenchWindow window) throws ExecutionException {
        IEditorPart editor;
        boolean saveOnCommandMenu = ForgeCorePreferences.INSTANCE.isSaveOnCommandMenu();
        boolean result = true;
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (editor = page.getActiveEditor()) != null && editor.isDirty()) {
            if (!saveOnCommandMenu) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)"Save Resource", (String)("'" + editor.getTitle() + "' has been modified. Save changes?\n (For Forge to access latest changes you need to save)"), (String)"Always save before opening the command dialog", (boolean)false, null, null);
                switch (dialog.getReturnCode()) {
                    case 1: {
                        result = false;
                        break;
                    }
                    case 2: {
                        saveOnCommandMenu = true;
                    }
                    default: {
                        if (!dialog.getToggleState()) break;
                        ForgeCorePreferences.INSTANCE.setSaveOnCommandMenu(true);
                    }
                }
            }
            if (saveOnCommandMenu) {
                result = page.saveEditor(editor, false);
            }
        }
        return result;
    }

    private void startForgeRuntime(ForgeRuntime runtime) {
        ForgeHelper.showForgeConsole(runtime);
        if (!ForgeRuntimeState.RUNNING.equals((Object)runtime.getState())) {
            ForgeHelper.start(runtime);
        }
    }
}

