/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.importer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;

public class ProjectImporter {
    private String baseDirPath;
    private String moduleLocation;
    private String projectName;

    public ProjectImporter(String baseDirPath, String moduleLocation, String projectName) {
        this.baseDirPath = baseDirPath;
        this.moduleLocation = moduleLocation;
        this.projectName = projectName;
    }

    public void importProject() {
        File projectDir = new File(this.baseDirPath, this.moduleLocation);
        File pomFile = new File(projectDir, "pom.xml");
        String name = "Importing project " + this.projectName;
        WorkspaceJob job = pomFile.isFile() ? new MavenImportWorkspaceJob(name) : new GeneralImportWorkspaceJob(name);
        job.setUser(true);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            ForgeUIPlugin.log(e);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProjectImporter.this.selectCreatedProject();
            }
        });
    }

    private Collection<MavenProjectInfo> getProjectToImport() {
        ArrayList<MavenProjectInfo> result = new ArrayList<MavenProjectInfo>(1);
        result.add(this.createMavenProjectInfo());
        return result;
    }

    private MavenProjectInfo createMavenProjectInfo() {
        MavenProjectInfo result = null;
        try {
            File projectDir = new File(this.baseDirPath, this.moduleLocation);
            File pomFile = new File(projectDir, "pom.xml");
            Model model = MavenPlugin.getMavenModelManager().readMavenModel(pomFile);
            String pomName = String.valueOf(this.moduleLocation) + "/" + "pom.xml";
            result = new MavenProjectInfo(pomName, pomFile, model, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void selectCreatedProject() {
        IWorkbenchWindow workbenchWindow;
        IWorkbenchPage workbenchPage;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(this.moduleLocation);
        if (project != null && (workbenchPage = (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage()) != null) {
            IViewPart packageExplorer;
            IViewPart projectExplorer = workbenchPage.findView("org.eclipse.ui.navigator.ProjectExplorer");
            if (projectExplorer instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)projectExplorer).selectReveal((ISelection)new StructuredSelection((Object)project));
            }
            if ((packageExplorer = workbenchPage.findView("org.eclipse.jdt.ui.PackageExplorer")) == null && projectExplorer == null) {
                try {
                    packageExplorer = workbenchPage.showView("org.eclipse.jdt.ui.PackageExplorer");
                }
                catch (PartInitException e) {
                    ForgeUIPlugin.log(e);
                }
            }
            if (packageExplorer instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)packageExplorer).selectReveal((ISelection)new StructuredSelection((Object)project));
            }
        }
    }

    private class GeneralImportWorkspaceJob
    extends WorkspaceJob {
        public GeneralImportWorkspaceJob(String name) {
            super(name);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            File projectDir = new File(ProjectImporter.this.baseDirPath, ProjectImporter.this.moduleLocation);
            IOverwriteQuery overwriteQuery = new IOverwriteQuery(){

                public String queryOverwrite(String file) {
                    return "ALL";
                }
            };
            IPath projectPath = Path.fromOSString((String)ProjectImporter.this.projectName);
            ImportOperation importOperation = new ImportOperation(projectPath, (Object)projectDir, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, overwriteQuery);
            importOperation.setCreateContainerStructure(false);
            try {
                importOperation.run(monitor);
            }
            catch (Exception exception) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }

    private class MavenImportWorkspaceJob
    extends WorkspaceJob {
        public MavenImportWorkspaceJob(String name) {
            super(name);
            this.setRule(MavenPlugin.getProjectConfigurationManager().getRule());
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            try {
                ProjectImportConfiguration config = new ProjectImportConfiguration();
                IProjectConfigurationManager configManager = MavenPlugin.getProjectConfigurationManager();
                Collection projectToImport = ProjectImporter.this.getProjectToImport();
                configManager.importProjects(projectToImport, config, monitor);
            }
            catch (CoreException ex) {
                return ex.getStatus();
            }
            return Status.OK_STATUS;
        }
    }
}

