/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.part;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.part.PageBook;
import org.jboss.tools.forge.ui.internal.console.ForgeConsole;
import org.jboss.tools.forge.ui.internal.console.ForgeConsoleManager;
import org.jboss.tools.forge.ui.internal.part.ForgeConsolePage;
import org.jboss.tools.forge.ui.internal.part.ForgeConsoleView;

public class ForgeConsolePageBook
extends PageBook {
    private ForgeConsoleView forgeConsoleView = null;
    private ForgeConsolePage currentPage = null;
    private Map<ForgeConsole, ForgeConsolePage> forgeConsoleToPage = new HashMap<ForgeConsole, ForgeConsolePage>();

    public ForgeConsolePageBook(ForgeConsoleView forgeConsoleView, Composite parent) {
        super(parent, 0);
        this.forgeConsoleView = forgeConsoleView;
        this.initializePages();
    }

    private void initializePages() {
        ForgeConsole[] forgeConsoleArray = ForgeConsoleManager.INSTANCE.getConsoles();
        int n = forgeConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ForgeConsole forgeConsole = forgeConsoleArray[n2];
            ForgeConsolePage forgeConsolePage = new ForgeConsolePage(this, forgeConsole);
            forgeConsolePage.initialize(this.getViewSite());
            forgeConsolePage.createControl();
            this.forgeConsoleToPage.put(forgeConsole, forgeConsolePage);
            ++n2;
        }
    }

    private IViewSite getViewSite() {
        return this.forgeConsoleView.getViewSite();
    }

    public void showForgeConsole(ForgeConsole forgeConsole) {
        ForgeConsolePage page;
        if (this.currentPage != null) {
            this.currentPage.deactivateActionBars();
        }
        if ((page = this.forgeConsoleToPage.get(forgeConsole)) != null) {
            page.show();
            page.activateActionBars();
            this.currentPage = page;
        }
        this.getViewSite().getActionBars().updateActionBars();
    }

    void updateStatusMessage(String message) {
        this.forgeConsoleView.setStatusMessage(message);
    }

    ForgeConsolePage getCurrentPage() {
        return this.currentPage;
    }
}

