/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.properties.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.foundation.core.internal.FoundationCorePlugin;
import org.jboss.tools.foundation.core.properties.IPropertiesProvider;

public class PropertiesProviderFactory {
    private static final String PROPERTIES_PROVIDERS_EXTENSION_ID = "org.jboss.tools.foundation.core.propertiesProviders";
    private static final String PROPERTIES_PROVIDER_KEY = "propertiesProvider";
    private static final String ATTR_CLASS = "class";
    private IPropertiesProvider propertiesProvider;

    List<IPropertiesProvider> loadPropertiesProviders() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PROPERTIES_PROVIDERS_EXTENSION_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        final HashMap<IPropertiesProvider, Integer> providersMap = new HashMap<IPropertiesProvider, Integer>(extensions.length);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (PROPERTIES_PROVIDER_KEY.equals(element.getName())) {
                    try {
                        IPropertiesProvider provider = (IPropertiesProvider)element.createExecutableExtension(ATTR_CLASS);
                        Integer priority = null;
                        try {
                            String prio = element.getAttribute("priority");
                            if (prio != null) {
                                priority = Integer.valueOf(prio);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            FoundationCorePlugin.pluginLog().logError("Invalid format for IPropertiesProvider priority", nfe);
                        }
                        if (priority == null) {
                            priority = 100;
                        }
                        providersMap.put(provider, priority);
                        break;
                    }
                    catch (Exception e) {
                        FoundationCorePlugin.pluginLog().logError("Unable to instanciate propertiesProvider", e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        ArrayList<IPropertiesProvider> providers = new ArrayList<IPropertiesProvider>(providersMap.keySet());
        Collections.sort(providers, new Comparator<IPropertiesProvider>(){

            @Override
            public int compare(IPropertiesProvider p1, IPropertiesProvider p2) {
                return ((Integer)providersMap.get(p2)).compareTo((Integer)providersMap.get(p1));
            }
        });
        return providers;
    }

    public synchronized IPropertiesProvider getPropertiesProvider() {
        List<IPropertiesProvider> providers;
        if (this.propertiesProvider == null && !(providers = this.loadPropertiesProviders()).isEmpty()) {
            this.propertiesProvider = providers.get(0);
        }
        return this.propertiesProvider;
    }
}

