/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.properties.internal;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SimpleHierarchicalVersion {
    private String internalVersion;
    private static final Pattern MILESTONES_PATTERN = Pattern.compile("^(Alpha|Beta|AM|RC|CR)(\\d+)$");

    public SimpleHierarchicalVersion(String version) {
        this.internalVersion = version;
    }

    public SimpleHierarchicalVersion getParentVersion() {
        String parentVersion = SimpleHierarchicalVersion.getOneVersionUp(this.internalVersion);
        if (parentVersion == null || this.internalVersion.equals(parentVersion)) {
            return null;
        }
        return new SimpleHierarchicalVersion(parentVersion);
    }

    static String getOneVersionUp(String version) {
        if (version == null) {
            return null;
        }
        if (version.endsWith("-SNAPSHOT")) {
            return version.substring(0, version.lastIndexOf("-SNAPSHOT"));
        }
        String[] segments = version.split("\\.");
        int newLength = 0;
        int curLength = segments.length;
        if (curLength > 3) {
            String qualifier = segments[3];
            int dashIndex = qualifier.lastIndexOf(45);
            newLength = 4;
            if (dashIndex > 0) {
                segments[3] = qualifier.substring(0, dashIndex);
            } else if (curLength == 4) {
                Matcher m = MILESTONES_PATTERN.matcher(qualifier);
                if (m.matches()) {
                    segments[3] = m.group(1);
                } else {
                    newLength = 3;
                }
            } else {
                newLength = curLength > 4 ? 4 : 3;
            }
        } else {
            newLength = segments.length - 1;
        }
        if (newLength > 0) {
            String[] newElements = Arrays.copyOf(segments, newLength);
            return Stream.of(newElements).collect(Collectors.joining("."));
        }
        return null;
    }

    public String toString() {
        return this.internalVersion;
    }
}

