/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.ui.credentials;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.foundation.core.credentials.CredentialService;
import org.jboss.tools.foundation.core.credentials.ICredentialDomain;
import org.jboss.tools.foundation.ui.credentials.ICredentialCompositeListener;
import org.jboss.tools.foundation.ui.credentials.internal.NewCredentialUserDialog;
import org.jboss.tools.foundation.ui.internal.FoundationUIPlugin;

public class ChooseCredentialComponent {
    protected ArrayList<ICredentialDomain> domainList;
    protected ArrayList<ICredentialCompositeListener> listeners = new ArrayList();
    protected String initialUsername;
    protected SelectionListener userComboListener;
    protected SelectionListener domainComboListener;
    protected Combo domainCombo;
    protected Combo userCombo;
    protected Label domainLabel;
    protected Label usernameLabel;
    protected Button addUser;
    protected Button editUser;

    public ChooseCredentialComponent() {
        this(null);
    }

    public ChooseCredentialComponent(String[] domains) {
        this(domains, null);
    }

    public ChooseCredentialComponent(String[] domains, String selectedUsername) {
        this.initialUsername = selectedUsername;
        this.domainList = this.findDomains(domains);
    }

    public void create(Composite parent) {
        this.createWidgets(parent);
        this.addWidgetListeners();
        this.refreshUserCombo(true);
    }

    protected void createWidgets(Composite parent) {
        this.domainLabel = new Label(parent, 0);
        this.domainLabel.setText("Domain: ");
        this.domainCombo = new Combo(parent, 8);
        this.domainCombo.setItems(this.findDomainNames(this.domainList));
        this.domainCombo.select(0);
        this.usernameLabel = new Label(parent, 0);
        this.usernameLabel.setText("Username: ");
        this.userCombo = new Combo(parent, 8);
        Composite editAddParent = parent;
        if (this.showEditButton()) {
            editAddParent = new Composite(parent, 0);
            editAddParent.setLayout((Layout)new GridLayout(2, false));
            this.editUser = new Button(editAddParent, 8);
            this.editUser.setText("Edit...");
        }
        this.addUser = new Button(editAddParent, 8);
        this.addUser.setText("Add...");
        if (this.domainList.size() == 1) {
            this.domainCombo.setEnabled(false);
        }
    }

    protected void addWidgetListeners() {
        this.domainComboListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseCredentialComponent.this.refreshUserCombo();
            }
        };
        this.domainCombo.addSelectionListener(this.domainComboListener);
        this.userComboListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseCredentialComponent.this.fireChanged();
            }
        };
        this.userCombo.addSelectionListener(this.userComboListener);
        this.addUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseCredentialComponent.this.addUserPressed();
            }
        });
        if (this.editUser != null) {
            this.editUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ChooseCredentialComponent.this.editUserPressed();
                }
            });
        }
    }

    private void editUserPressed() {
        NewCredentialUserDialog dialog = new NewCredentialUserDialog(this.domainCombo.getShell(), CredentialService.getCredentialModel(), this.getDomain(), this.getUser());
        if (dialog.open() == 0) {
            CredentialService.getCredentialModel().removeCredentials(this.getDomain(), this.getUser());
            this.credentialDialogOkPressed(dialog);
        }
    }

    private void addUserPressed() {
        NewCredentialUserDialog dialog = new NewCredentialUserDialog(this.domainCombo.getShell(), CredentialService.getCredentialModel(), this.getDomain());
        if (dialog.open() == 0) {
            this.credentialDialogOkPressed(dialog);
        }
    }

    private void credentialDialogOkPressed(NewCredentialUserDialog dialog) {
        ICredentialDomain cd = dialog.getDomain();
        String name = dialog.getUser();
        String pass = dialog.getPass();
        if (dialog.isAlwaysPrompt()) {
            CredentialService.getCredentialModel().addPromptedCredentials(cd, name);
        } else {
            CredentialService.getCredentialModel().addCredentials(cd, name, pass);
        }
        CredentialService.getCredentialModel().save();
        this.refreshUserCombo(name, true);
    }

    private void refreshUserCombo() {
        this.refreshUserCombo(false);
    }

    private void refreshUserCombo(boolean initial) {
        if (initial) {
            this.refreshUserCombo(this.initialUsername, false);
        } else {
            this.refreshUserCombo(null, true);
        }
    }

    private void refreshUserCombo(String user, boolean fire) {
        ICredentialDomain d = this.getDomain();
        if (d != null) {
            String[] userNames = d.getUsernames();
            this.userCombo.setItems(userNames);
            if (userNames.length > 0) {
                if (user == null) {
                    this.userCombo.select(0);
                } else {
                    int ind = Arrays.asList(userNames).indexOf(user);
                    if (ind == -1) {
                        this.userCombo.select(0);
                    } else {
                        this.userCombo.select(ind);
                    }
                }
            }
        }
        if (this.editUser != null) {
            this.editUser.setEnabled(this.userCombo.getSelectionIndex() != -1);
        }
        if (fire) {
            this.fireChanged();
        }
        this.userCombo.getParent().layout(false, false);
        this.userCombo.getParent().update();
    }

    protected void fireChanged() {
        Iterator<ICredentialCompositeListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().credentialsChanged();
        }
    }

    protected boolean showEditButton() {
        return true;
    }

    private String[] findDomainNames(List<ICredentialDomain> domains) {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator<ICredentialDomain> it = domains.iterator();
        while (it.hasNext()) {
            String name = it.next().getName();
            ret.add(name);
        }
        return ret.toArray(new String[ret.size()]);
    }

    private ArrayList<ICredentialDomain> findDomains(String[] domains) {
        ArrayList<ICredentialDomain> list = new ArrayList<ICredentialDomain>();
        if (domains == null) {
            ICredentialDomain[] domainArr = CredentialService.getCredentialModel().getDomains();
            list.addAll(Arrays.asList(domainArr));
        } else {
            int i = 0;
            while (i < domains.length) {
                ICredentialDomain domain = CredentialService.getCredentialModel().getDomain(domains[i]);
                if (domain != null) {
                    list.add(domain);
                }
                ++i;
            }
        }
        return list;
    }

    public void addCredentialListener(ICredentialCompositeListener listener) {
        this.listeners.add(listener);
    }

    public void removeCredentialListener(ICredentialCompositeListener listener) {
        this.listeners.remove(listener);
    }

    public ICredentialDomain getDomain() {
        int ind = this.domainCombo.getSelectionIndex();
        if (ind != -1) {
            ICredentialDomain d = this.domainList.get(ind);
            return d;
        }
        return null;
    }

    public String getUser() {
        int userIndex = this.userCombo.getSelectionIndex();
        return userIndex == -1 ? null : this.userCombo.getItem(userIndex);
    }

    public String getPassword() {
        ICredentialDomain cd = this.getDomain();
        if (cd != null) {
            try {
                return cd.getPassword(this.getUser());
            }
            catch (StorageException se) {
                FoundationUIPlugin.pluginLog().logError((Throwable)se);
            }
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.domainCombo.setEnabled(false);
            this.userCombo.setEnabled(false);
        } else {
            this.domainCombo.setEnabled(this.domainList.size() != 1);
            this.userCombo.setEnabled(true);
        }
    }

    public void gridLayout(int n) {
        if (n == 2) {
            GridData gd2 = new GridData();
            gd2.widthHint = 200;
            this.domainCombo.setLayoutData((Object)gd2);
            this.userCombo.setLayoutData((Object)gd2);
            GridData gd3 = new GridData();
            gd3.horizontalSpan = 2;
            this.addUser.setLayoutData((Object)gd3);
        } else if (n >= 3) {
            GridData domainData = new GridData();
            domainData.widthHint = 200;
            domainData.horizontalSpan = n - 1;
            domainData.horizontalAlignment = 4;
            this.domainCombo.setLayoutData((Object)domainData);
            GridData userData = new GridData();
            userData.widthHint = 200;
            userData.horizontalSpan = n - 2;
            userData.grabExcessHorizontalSpace = true;
            userData.horizontalAlignment = 4;
            this.userCombo.setLayoutData((Object)userData);
            GridData gd3 = new GridData();
            gd3.horizontalAlignment = 4;
            this.addUser.setLayoutData((Object)gd3);
        }
    }

    public Combo getUserCombo() {
        return this.userCombo;
    }

    public Combo getDomainCombo() {
        return this.domainCombo;
    }

    public SelectionListener getUserListener() {
        return this.userComboListener;
    }

    public SelectionListener getDomainListener() {
        return this.domainComboListener;
    }
}

