/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.ui.credentials.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.foundation.core.ecf.URLTransportUtility;
import org.jboss.tools.foundation.ui.internal.FoundationUIPlugin;
import org.jboss.tools.foundation.ui.plugin.BaseUISharedImages;
import org.jboss.tools.magicfile4j.IMagicFileModel;
import org.jboss.tools.magicfile4j.MagicFileLoader;
import org.jboss.tools.magicfile4j.MagicResult;
import org.jboss.tools.magicfile4j.MagicRunner;
import org.osgi.framework.Bundle;

public class FaviconCache
extends BaseUISharedImages {
    private static final FaviconCache instance = new FaviconCache(FoundationUIPlugin.getDefault().getBundle());
    private static final String FAVICONS = "favicons";
    private static final String DOT_ICO = ".ico";
    private static final String[] allowedFormats = new String[]{"image/vnd.microsoft.icon", "image/x-icon", "image/png", "image/gif", "image/jpeg", "image/svg+xml"};
    private Set<String> failedLoads = new HashSet<String>();
    private IMagicFileModel magicModel = null;
    private boolean magicLoadFailed = false;

    public static FaviconCache getDefault() {
        return instance;
    }

    public FaviconCache(Bundle pluginBundle) {
        super(pluginBundle);
        this.init();
    }

    private void init() {
        IPath p = FoundationUIPlugin.getDefault().getStateLocation().append(FAVICONS);
        if (p.toFile().exists()) {
            File[] all = p.toFile().listFiles();
            int i = 0;
            while (i < all.length) {
                if (all[i].getName().endsWith(DOT_ICO)) {
                    String host = all[i].getName().substring(0, all[i].getName().lastIndexOf("."));
                    this.addImage(host, all[i].getName());
                }
                ++i;
            }
        } else {
            p.toFile().mkdirs();
        }
    }

    public void loadFavicon(final String host, final FaviconCacheListener listener) {
        new Thread("Load favicon.ico for " + host){

            @Override
            public void run() {
                FaviconCache.this.loadFaviconSync(host, listener);
            }
        }.start();
    }

    private void loadFaviconSync(String host, FaviconCacheListener listener) {
        File f = this.fetchFaviconSync(host, listener);
        if (f == null) {
            this.failedLoads.add(host);
            listener.fetchFailed(host);
        } else {
            String fileType = this.getMimeType(f);
            if (fileType == null || !Arrays.asList(allowedFormats).contains(fileType)) {
                this.failedLoads.add(host);
                listener.fetchFailed(host);
            } else {
                boolean success;
                String target;
                IPath p = FoundationUIPlugin.getDefault().getStateLocation().append(FAVICONS);
                File targetFile = p.append(target = String.valueOf(host) + DOT_ICO).toFile();
                if (targetFile.exists()) {
                    targetFile.delete();
                }
                if (success = f.renameTo(targetFile)) {
                    this.addImage(host, target);
                    listener.iconCached(host);
                } else {
                    this.failedLoads.add(host);
                    listener.fetchFailed(host);
                }
            }
        }
    }

    private String getMimeType(File f) {
        if (f == null || !f.exists()) {
            return null;
        }
        IMagicFileModel mod = this.getMagicModel();
        try {
            MagicResult result = new MagicRunner(mod).runMatcher(f);
            if (result != null) {
                return result.getMimeType();
            }
        }
        catch (IOException ioe) {
            FoundationUIPlugin.pluginLog().logError("Error reading file type for file " + f.getName(), (Throwable)ioe);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IMagicFileModel getMagicModel() {
        if (this.magicModel != null || this.magicLoadFailed) return this.magicModel;
        URL url = null;
        InputStream inputStream = null;
        IMagicFileModel model = null;
        try {
            url = new URL("platform:/plugin/org.jboss.tools.foundation.ui/resources/images.magic");
            inputStream = url.openConnection().getInputStream();
            this.magicModel = model = new MagicFileLoader().readMagicFile(inputStream);
        }
        catch (MalformedURLException e) {
            this.magicLoadFailed = true;
            FoundationUIPlugin.pluginLog().logError("Error loading magic file for verifying image types", (Throwable)e);
            if (inputStream == null) return this.magicModel;
            try {
                inputStream.close();
                return this.magicModel;
            }
            catch (IOException iOException) {}
            return this.magicModel;
        }
        catch (IOException ioe) {
            try {
                this.magicLoadFailed = true;
                FoundationUIPlugin.pluginLog().logError("Error loading magic file for verifying image types", (Throwable)ioe);
                if (inputStream == null) return this.magicModel;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
                return this.magicModel;
            }
            catch (IOException iOException) {}
            return this.magicModel;
        }
        if (inputStream == null) return this.magicModel;
        try {
            inputStream.close();
            return this.magicModel;
        }
        catch (IOException iOException) {}
        return this.magicModel;
    }

    public boolean loadFailed(String host) {
        return this.failedLoads.contains(host);
    }

    private File fetchFaviconSync(String host, FaviconCacheListener listener) {
        try {
            String url = "http://" + host + "/favicon.ico";
            File f = new URLTransportUtility().getCachedFileForURL(url, "Fetching favicon for " + host, 2, (IProgressMonitor)new NullProgressMonitor());
            if (f != null && f.length() > 0L) {
                return f;
            }
        }
        catch (CoreException ce) {
            FoundationUIPlugin.pluginLog().logError((Throwable)ce);
        }
        return null;
    }

    public ImageDescriptor getDescriptorForHost(String host) {
        return this.descriptor(host);
    }

    public Image getImageForHost(String host) {
        try {
            return this.image(host);
        }
        catch (SWTException sWTException) {
            return null;
        }
    }

    @Override
    protected ImageDescriptor createImageDescriptor(String path) {
        try {
            IPath p = FoundationUIPlugin.getDefault().getStateLocation().append(FAVICONS);
            p = p.append(path);
            return ImageDescriptor.createFromURL((URL)p.toFile().toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            FoundationUIPlugin.pluginLog().logError("Error generating favicon image descriptor for host " + path);
            return null;
        }
    }

    public static void cleanup() {
        instance.dispose();
    }

    public static interface FaviconCacheListener {
        public void iconCached(String var1);

        public void fetchFailed(String var1);
    }
}

