/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.ui.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.foundation.ui.widget.WidgetVisitorUtility;

public class DisableAllWidgetsJob
extends UIJob {
    private boolean disableWidgets;
    private Cursor cursor;
    private boolean disableCursor;
    private Composite container;

    public DisableAllWidgetsJob(boolean disable, Composite container, Cursor cursor) {
        this(disable, container, disable, cursor);
    }

    public DisableAllWidgetsJob(boolean disableWidgets, Composite container, boolean disableCursor, Cursor cursor) {
        super(String.valueOf(disableWidgets ? "Disabling" : "Enabling") + " all controls...");
        this.disableWidgets = disableWidgets;
        this.container = container;
        this.disableCursor = disableCursor;
        this.cursor = cursor;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        this.run();
        return Status.OK_STATUS;
    }

    public void run() {
        if (this.container.isDisposed()) {
            return;
        }
        new WidgetVisitorUtility().setEnablementRecursive(this.container, !this.disableWidgets);
        if (!this.disableCursor) {
            this.container.setCursor(null);
            if (this.cursor != null) {
                this.cursor.dispose();
            }
        } else if (this.cursor != null) {
            this.container.setCursor(this.cursor);
        }
    }
}

