/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.core.camel;

import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;

public final class EndpointHelper {
    public static final String DOZER_SCHEME = "dozer";
    private static final String SOURCE_MODEL = "sourceModel";
    private static final String TARGET_MODEL = "targetModel";
    private static final String MARSHAL_ID = "marshalId";
    private static final String UNMARSHAL_ID = "unmarshalId";
    public static final String MAPPING_FILE = "mappingFile";

    public static String createEndpointUri(String dozerConfigPath, String transformId, String sourceClass, String targetClass, String unmarshallerId, String marshallerId) {
        StringBuilder uriBuf = new StringBuilder("dozer:" + transformId + "?");
        uriBuf.append("sourceModel=" + sourceClass);
        uriBuf.append("&targetModel=" + targetClass);
        if (marshallerId != null) {
            uriBuf.append("&marshalId=" + marshallerId);
        }
        if (unmarshallerId != null) {
            uriBuf.append("&unmarshalId=" + unmarshallerId);
        }
        if (dozerConfigPath != null) {
            uriBuf.append("&mappingFile=" + dozerConfigPath);
        }
        return uriBuf.toString();
    }

    public static void setSourceModel(AbstractCamelModelElement endpoint, String sourceModel) {
        EndpointHelper.replaceEndpointParameter(endpoint, SOURCE_MODEL, sourceModel);
    }

    public static void setTargetModel(AbstractCamelModelElement endpoint, String targetModel) {
        EndpointHelper.replaceEndpointParameter(endpoint, TARGET_MODEL, targetModel);
    }

    public static void replaceEndpointParameter(AbstractCamelModelElement endpoint, String key, String val) {
        StringBuilder uriStr = new StringBuilder((String)endpoint.getParameter("uri"));
        if (uriStr.indexOf(String.valueOf(key) + "=") < 0) {
            throw new IllegalArgumentException("Endpoint does not contain parameter: " + key);
        }
        int startIdx = uriStr.indexOf(key);
        int endIdx = uriStr.indexOf("&", startIdx);
        if (endIdx < 0) {
            endIdx = uriStr.length();
        }
        uriStr.replace(startIdx, endIdx, String.valueOf(key) + "=" + val);
        endpoint.setParameter("uri", (Object)uriStr.toString());
    }
}

