/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.core.dozer;

import org.jboss.tools.fuse.transformation.core.Expression;
import org.jboss.tools.fuse.transformation.core.dozer.TransformationArgumentHelper;
import org.jboss.tools.fuse.transformation.core.dozer.config.Field;

public class DozerExpression
implements Expression {
    private static final String SEP = ":";
    private Field field;

    public DozerExpression(Field field) {
        this.field = field;
    }

    @Override
    public String getLanguage() {
        return TransformationArgumentHelper.getArgumentPart(this.field, SEP, 0);
    }

    @Override
    public void setLanguage(String language) {
        this.field.setCustomConverterArgument(String.valueOf(language) + SEP + TransformationArgumentHelper.emptyForNull(this.getExpression()));
    }

    @Override
    public String getExpression() {
        String nextPart = TransformationArgumentHelper.getArgumentPart(this.field, SEP, 1);
        if (nextPart.equalsIgnoreCase("resource")) {
            String scheme = TransformationArgumentHelper.getArgumentPart(this.field, SEP, 2);
            String path = TransformationArgumentHelper.getArgumentPart(this.field, SEP, 3);
            if (scheme != null && path != null) {
                return String.valueOf(nextPart) + SEP + scheme + SEP + path;
            }
        }
        return nextPart;
    }

    @Override
    public void setExpression(String expression) {
        this.field.setCustomConverterArgument(String.valueOf(TransformationArgumentHelper.emptyForNull(this.getLanguage())) + SEP + expression);
    }

    public String toString() {
        return "expression[language:" + this.getLanguage() + ",expr:" + this.getExpression() + "]";
    }
}

