/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.core.dozer;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.jboss.tools.fuse.transformation.core.FieldMapping;
import org.jboss.tools.fuse.transformation.core.MapperConfiguration;
import org.jboss.tools.fuse.transformation.core.MappingOperation;
import org.jboss.tools.fuse.transformation.core.TransformationMapping;
import org.jboss.tools.fuse.transformation.core.dozer.BaseDozerMapping;
import org.jboss.tools.fuse.transformation.core.dozer.DozerExpression;
import org.jboss.tools.fuse.transformation.core.dozer.DozerExpressionMapping;
import org.jboss.tools.fuse.transformation.core.dozer.DozerFieldMapping;
import org.jboss.tools.fuse.transformation.core.dozer.DozerTransformationMapping;
import org.jboss.tools.fuse.transformation.core.dozer.DozerUtil;
import org.jboss.tools.fuse.transformation.core.dozer.DozerVariable;
import org.jboss.tools.fuse.transformation.core.dozer.DozerVariableMapping;
import org.jboss.tools.fuse.transformation.core.dozer.config.Class;
import org.jboss.tools.fuse.transformation.core.dozer.config.Configuration;
import org.jboss.tools.fuse.transformation.core.dozer.config.Field;
import org.jboss.tools.fuse.transformation.core.dozer.config.FieldDefinition;
import org.jboss.tools.fuse.transformation.core.dozer.config.Mapping;
import org.jboss.tools.fuse.transformation.core.dozer.config.Mappings;
import org.jboss.tools.fuse.transformation.core.dozer.config.ObjectFactory;
import org.jboss.tools.fuse.transformation.core.dozer.config.Variable;
import org.jboss.tools.fuse.transformation.core.dozer.config.Variables;
import org.jboss.tools.fuse.transformation.core.model.Model;
import org.jboss.tools.fuse.transformation.core.model.ModelBuilder;

public class DozerMapperConfiguration
implements MapperConfiguration {
    public static final String DEFAULT_DOZER_CONFIG = "dozerBeanMapping.xml";
    private static final String VARIABLE_MAPPER_CLASS = "org.apache.camel.component.dozer.VariableMapper";
    private static final String EXPRESSION_MAPPER_CLASS = "org.apache.camel.component.dozer.ExpressionMapper";
    private static final String VARIABLE_MAPPER_ID = "_variableMapping";
    private static final String CUSTOM_MAPPER_ID = "_customMapping";
    private static final String EXPRESSION_MAPPER_ID = "_expressionMapping";
    private static final String DOZER_SCHEMA_LOC = "http://dozermapper.github.io/schema/bean-mapping https://dozermapper.github.io/schema/bean-mapping.xsd";
    private JAXBContext jaxbCtx;
    private ClassLoader loader;
    private final Mappings mapConfig;
    private Model sourceModel;
    private Model targetModel;
    private final Model variableModel = new Model("variables", "org.apache.camel.component.dozer.VariableMapper").addChild("literal", String.class.getName());
    private final Model expressionModel = new Model("expressions", "org.apache.camel.component.dozer.ExpressionMapper").addChild("expression", String.class.getName());

    public static DozerMapperConfiguration loadConfig(File file) throws JAXBException {
        return new DozerMapperConfiguration(file, null);
    }

    public static DozerMapperConfiguration loadConfig(File file, ClassLoader loader) throws JAXBException {
        return new DozerMapperConfiguration(file, loader);
    }

    public static DozerMapperConfiguration loadConfig(InputStream stream) throws JAXBException {
        return new DozerMapperConfiguration(stream, null);
    }

    public static DozerMapperConfiguration loadConfig(InputStream stream, ClassLoader loader) throws JAXBException {
        return new DozerMapperConfiguration(stream, loader);
    }

    public static DozerMapperConfiguration newConfig(ClassLoader loader) {
        DozerMapperConfiguration config = new DozerMapperConfiguration(loader);
        Configuration dozerConfig = config.getDozerConfig().getConfiguration();
        if (dozerConfig == null) {
            dozerConfig = new Configuration();
            config.getDozerConfig().setConfiguration(dozerConfig);
        }
        dozerConfig.setWildcard(false);
        return config;
    }

    private DozerMapperConfiguration(File file, ClassLoader loader) throws JAXBException {
        this.mapConfig = (Mappings)this.getJAXBContext().createUnmarshaller().unmarshal(file);
        this.loader = loader;
    }

    private DozerMapperConfiguration(InputStream stream, ClassLoader loader) throws JAXBException {
        this.mapConfig = (Mappings)this.getJAXBContext().createUnmarshaller().unmarshal(stream);
        this.loader = loader;
    }

    private DozerMapperConfiguration(ClassLoader loader) {
        this.mapConfig = new Mappings();
        this.loader = loader;
    }

    @Override
    public void addClassMapping(String fromClass, String toClass) {
        this.mapClass(fromClass, toClass);
    }

    DozerFieldMapping addFieldMapping(Model source, Model target, List<Integer> sourceIndex, List<Integer> targetIndex) {
        if (this.hasCollectionAncestor(source) && this.hasCollectionAncestor(target)) {
            this.mapParentCollection(source, target);
        }
        Mapping mapping = this.getClassMapping(source, target, sourceIndex, targetIndex);
        Field field = new Field();
        field.setA(this.createField(source, mapping.getClassA().getContent(), sourceIndex));
        field.setB(this.createField(target, mapping.getClassB().getContent(), targetIndex));
        mapping.getFieldOrFieldExclude().add(field);
        return new DozerFieldMapping(source, target, mapping, field);
    }

    @Override
    public org.jboss.tools.fuse.transformation.core.Variable addVariable(String name, String value) {
        org.jboss.tools.fuse.transformation.core.Variable variable = this.getVariable(name);
        if (variable != null) {
            variable.setValue(value);
        } else {
            variable = this.createVariable(name, value);
        }
        return variable;
    }

    FieldDefinition createField(Model model, String rootType) {
        return this.createField(model, rootType, DozerUtil.noIndex(model));
    }

    FieldDefinition createField(Model model, String rootType, List<Integer> indexes) {
        FieldDefinition fd = new FieldDefinition();
        fd.setContent(DozerUtil.getFieldName(model, rootType, indexes));
        return fd;
    }

    private org.jboss.tools.fuse.transformation.core.Variable createVariable(String name, String value) {
        Variables variables;
        Configuration dozerConfig = this.mapConfig.getConfiguration();
        if (dozerConfig == null) {
            dozerConfig = new Configuration();
            this.mapConfig.setConfiguration(dozerConfig);
        }
        if ((variables = dozerConfig.getVariables()) == null) {
            variables = new Variables();
            dozerConfig.setVariables(variables);
        }
        Variable dozerVar = new Variable();
        dozerVar.setName(name);
        dozerVar.setContent(value);
        variables.getVariable().add(dozerVar);
        return new DozerVariable(dozerVar);
    }

    public Mapping getClassMapping(Model source, Model target) {
        return this.getClassMapping(this.getRootType(source), this.getRootType(target));
    }

    Mapping getClassMapping(Model source, Model target, List<Integer> sourceIndex, List<Integer> targetIndex) {
        return this.getClassMapping(this.getRootType(source, sourceIndex), this.getRootType(target, targetIndex));
    }

    Mapping getClassMapping(String sourceType, String targetType) {
        for (Mapping m : this.mapConfig.getMapping()) {
            if (!m.getClassA().getContent().equals(sourceType) || !m.getClassB().getContent().equals(targetType)) continue;
            return m;
        }
        return null;
    }

    public Mappings getDozerConfig() {
        return this.mapConfig;
    }

    Mapping getExtendedMapping(String sourceClass, Model target, List<Integer> index) {
        Mapping mapping = null;
        for (Mapping m : this.mapConfig.getMapping()) {
            if (!m.getClassA().getContent().equals(sourceClass) || !m.getClassB().getContent().equals(this.getRootType(target, index))) continue;
            mapping = m;
            break;
        }
        if (mapping == null) {
            mapping = this.mapClass(sourceClass, this.getRootType(target, index));
        }
        return mapping;
    }

    private synchronized JAXBContext getJAXBContext() {
        if (this.jaxbCtx == null) {
            try {
                this.jaxbCtx = JAXBContext.newInstance((java.lang.Class[])new java.lang.Class[]{ObjectFactory.class});
            }
            catch (JAXBException jaxbEx) {
                throw new RuntimeException(jaxbEx);
            }
        }
        return this.jaxbCtx;
    }

    @Override
    public MappingOperation<?, ?> getMapping(Model source, Model target) {
        MappingOperation<?, ?> mapping = null;
        for (MappingOperation<?, ?> op : this.getMappings()) {
            if (!op.getSource().equals(source) || !op.getTarget().equals(target)) continue;
            mapping = op;
            break;
        }
        return mapping;
    }

    @Override
    public List<MappingOperation<?, ?>> getMappings() {
        LinkedList mappings = new LinkedList();
        for (Mapping mapping : this.mapConfig.getMapping()) {
            String targetType = mapping.getClassB().getContent();
            for (Object o : mapping.getFieldOrFieldExclude()) {
                if (!(o instanceof Field)) continue;
                Field field = (Field)o;
                Model targetModel = this.getModel(this.getTargetModel(), targetType, field.getB().getContent());
                if (VARIABLE_MAPPER_ID.equals(field.getCustomConverterId())) {
                    org.jboss.tools.fuse.transformation.core.Variable variable = this.getVariable(DozerVariableMapping.unqualifyName(field.getCustomConverterArgument()));
                    mappings.add(new DozerVariableMapping(variable, targetModel, mapping, field));
                    continue;
                }
                if (EXPRESSION_MAPPER_ID.equals(field.getCustomConverterId())) {
                    DozerExpression expression = new DozerExpression(field);
                    mappings.add(new DozerExpressionMapping(expression, targetModel, mapping, field));
                    continue;
                }
                String sourceType = mapping.getClassA().getContent();
                Model sourceModel = this.getModel(this.getSourceModel(), sourceType, field.getA().getContent());
                DozerFieldMapping fieldMapping = new DozerFieldMapping(sourceModel, targetModel, mapping, field);
                if (CUSTOM_MAPPER_ID.equals(field.getCustomConverterId())) {
                    fieldMapping = new DozerTransformationMapping(fieldMapping);
                }
                mappings.add(fieldMapping);
            }
        }
        return mappings;
    }

    @Override
    public List<MappingOperation<?, ?>> getMappingsForSource(Model source) {
        LinkedList sourceMappings = new LinkedList();
        for (MappingOperation<?, ?> op : this.getMappings()) {
            if (!op.getSource().equals(source)) continue;
            sourceMappings.add(op);
        }
        return sourceMappings;
    }

    @Override
    public List<MappingOperation<?, ?>> getMappingsForTarget(Model target) {
        LinkedList targetMappings = new LinkedList();
        for (MappingOperation<?, ?> op : this.getMappings()) {
            if (!op.getTarget().equals(target)) continue;
            targetMappings.add(op);
        }
        return targetMappings;
    }

    private Model getModel(Model model, String type, String fieldName) {
        String name = DozerUtil.removeIndexes(fieldName);
        if (type.equals(model.getType()) && name.equals(model.getName())) {
            return model;
        }
        Model found = model.get(name);
        if (found == null) {
            for (Model childModel : model.getChildren()) {
                found = childModel.isCollection() ? this.getModel(childModel, childModel.getType(), name) : this.getModel(childModel, type, name);
                if (found != null) break;
            }
        }
        return found;
    }

    private Model getParentCollection(Model model) {
        if (model.getParent() == null) {
            return null;
        }
        return model.getParent().isCollection() ? model.getParent() : this.getParentCollection(model.getParent());
    }

    Mapping getRootMapping() {
        Mapping root = null;
        if (!this.mapConfig.getMapping().isEmpty()) {
            root = this.mapConfig.getMapping().get(0);
        }
        return root;
    }

    public String getRootType(Model field) {
        return this.getRootType(field, DozerUtil.noIndex(field));
    }

    String getRootType(Model field, List<Integer> index) {
        Model root = field.getParent();
        int i = index.size() - 2;
        while (i >= 0) {
            if (root.getParent() == null || root.isCollection() && index.get(i) == null) break;
            root = root.getParent();
            --i;
        }
        return root.isCollection() ? ModelBuilder.getListType(root.getType()) : root.getType();
    }

    @Override
    public synchronized Model getSourceModel() {
        Mapping root;
        if (this.sourceModel == null && (root = this.getRootMapping()) != null && root.getClassA() != null) {
            this.sourceModel = this.loadModel(root.getClassA().getContent());
        }
        return this.sourceModel;
    }

    @Override
    public synchronized Model getTargetModel() {
        Mapping root;
        if (this.targetModel == null && (root = this.getRootMapping()) != null && root.getClassB() != null) {
            this.targetModel = this.loadModel(root.getClassB().getContent());
        }
        return this.targetModel;
    }

    @Override
    public org.jboss.tools.fuse.transformation.core.Variable getVariable(String variableName) {
        org.jboss.tools.fuse.transformation.core.Variable variable = null;
        for (org.jboss.tools.fuse.transformation.core.Variable var : this.getVariables()) {
            if (!var.getName().equals(variableName)) continue;
            variable = var;
            break;
        }
        return variable;
    }

    @Override
    public List<org.jboss.tools.fuse.transformation.core.Variable> getVariables() {
        LinkedList<org.jboss.tools.fuse.transformation.core.Variable> variableList = new LinkedList<org.jboss.tools.fuse.transformation.core.Variable>();
        if (this.mapConfig.getConfiguration() == null || this.mapConfig.getConfiguration().getVariables() == null) {
            return variableList;
        }
        Variables dozerVars = this.mapConfig.getConfiguration().getVariables();
        for (Variable dozerVar : dozerVars.getVariable()) {
            variableList.add(new DozerVariable(dozerVar));
        }
        return variableList;
    }

    private boolean hasCollectionAncestor(Model model) {
        return this.getParentCollection(model) != null;
    }

    private Model loadModel(String className) {
        try {
            java.lang.Class<?> modelClass = this.loader != null ? this.loader.loadClass(className) : java.lang.Class.forName(className);
            return ModelBuilder.fromJavaClass(modelClass);
        }
        catch (ClassNotFoundException cnfEx) {
            throw new RuntimeException(cnfEx);
        }
    }

    Mapping mapClass(String sourceClass, String targetClass) {
        Mapping map = new Mapping();
        Class classA = new Class();
        Class classB = new Class();
        classA.setContent(sourceClass);
        classB.setContent(targetClass);
        map.setClassA(classA);
        map.setClassB(classB);
        this.mapConfig.getMapping().add(map);
        return map;
    }

    @Override
    public DozerExpressionMapping mapExpression(String language, String expression, Model target) {
        return this.mapExpression(language, expression, target, (List)DozerUtil.noIndex(target));
    }

    @Override
    public DozerExpressionMapping mapExpression(String language, String expression, Model target, List<Integer> targetIndex) {
        Mapping mapping = this.getExtendedMapping(EXPRESSION_MAPPER_CLASS, target, targetIndex);
        Field field = new Field();
        field.setA(this.createField(this.expressionModel, EXPRESSION_MAPPER_CLASS));
        field.setB(this.createField(target, mapping.getClassB().getContent(), targetIndex));
        DozerExpression dozerExpression = new DozerExpression(field);
        dozerExpression.setExpression(expression);
        dozerExpression.setLanguage(language);
        field.setCustomConverterId(EXPRESSION_MAPPER_ID);
        mapping.getFieldOrFieldExclude().add(field);
        return new DozerExpressionMapping(dozerExpression, target, mapping, field);
    }

    @Override
    public DozerFieldMapping mapField(Model source, Model target) {
        return this.mapField(source, target, (List)DozerUtil.noIndex(source), (List)DozerUtil.noIndex(target));
    }

    @Override
    public DozerFieldMapping mapField(Model source, Model target, List<Integer> sourceIndex, List<Integer> targetIndex) {
        this.validateIndex(source, sourceIndex);
        this.validateIndex(target, targetIndex);
        if (this.getClassMapping(source, target, sourceIndex, targetIndex) == null) {
            this.addClassMapping(this.getRootType(source, sourceIndex), this.getRootType(target, targetIndex));
        }
        return this.addFieldMapping(source, target, sourceIndex, targetIndex);
    }

    private void mapParentCollection(Model source, Model target) {
        Model targetParent;
        Model sourceParent = this.getParentCollection(source);
        if (this.getMapping(sourceParent, targetParent = this.getParentCollection(target)) == null) {
            this.addFieldMapping(source.getParent(), target.getParent(), DozerUtil.noIndex(source.getParent()), DozerUtil.noIndex(target.getParent()));
        }
    }

    @Override
    public DozerVariableMapping mapVariable(org.jboss.tools.fuse.transformation.core.Variable variable, Model target) {
        return this.mapVariable(variable, target, (List)DozerUtil.noIndex(target));
    }

    @Override
    public DozerVariableMapping mapVariable(org.jboss.tools.fuse.transformation.core.Variable variable, Model target, List<Integer> targetIndex) {
        Mapping mapping = this.getExtendedMapping(VARIABLE_MAPPER_CLASS, target, targetIndex);
        Field field = new Field();
        field.setA(this.createField(this.variableModel, VARIABLE_MAPPER_CLASS));
        field.setB(this.createField(target, mapping.getClassB().getContent(), targetIndex));
        field.setCustomConverterId(VARIABLE_MAPPER_ID);
        field.setCustomConverterArgument(DozerVariableMapping.qualifyName(variable.getName()));
        mapping.getFieldOrFieldExclude().add(field);
        return new DozerVariableMapping(variable, target, mapping, field);
    }

    @Override
    public void removeAllMappings() {
        this.mapConfig.getMapping().clear();
    }

    @Override
    public void removeMapping(MappingOperation<?, ?> mapping) {
        ((BaseDozerMapping)((Object)mapping)).delete();
    }

    @Override
    public boolean removeVariable(org.jboss.tools.fuse.transformation.core.Variable variable) {
        if (this.mapConfig.getConfiguration() == null || this.mapConfig.getConfiguration().getVariables() == null) {
            return false;
        }
        Variables dozerVars = this.mapConfig.getConfiguration().getVariables();
        Iterator<Variable> varIt = dozerVars.getVariable().iterator();
        boolean removed = false;
        while (varIt.hasNext()) {
            Variable dozerVar = varIt.next();
            if (!dozerVar.getName().equals(variable.getName())) continue;
            varIt.remove();
            removed = true;
            break;
        }
        if (dozerVars.getVariable().isEmpty()) {
            this.mapConfig.getConfiguration().setVariables(null);
        }
        return removed;
    }

    @Override
    public void saveConfig(OutputStream output) throws Exception {
        Marshaller m = this.getJAXBContext().createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
        m.setProperty("jaxb.schemaLocation", (Object)DOZER_SCHEMA_LOC);
        m.marshal((Object)this.mapConfig, output);
    }

    @Override
    public TransformationMapping setTransformation(FieldMapping mapping, String transformationClass, String transformationName, String ... transformationArguments) {
        DozerFieldMapping fieldMapping = (DozerFieldMapping)mapping;
        fieldMapping.getField().setCustomConverterId(CUSTOM_MAPPER_ID);
        DozerTransformationMapping xfromMapping = new DozerTransformationMapping(fieldMapping);
        xfromMapping.setTransformationClass(transformationClass);
        xfromMapping.setTransformationName(transformationName);
        xfromMapping.addTransformationArguments(transformationArguments);
        return xfromMapping;
    }

    private void validateIndex(Model model, List<Integer> index) {
        int nodes = DozerUtil.numberOfNodes(model);
        if (nodes != index.size()) {
            throw new RuntimeException("Invalid index size for model, expected " + nodes + " but index size is " + index.size());
        }
    }
}

