/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.core.model;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Model {
    private Class<?> modelClass;
    private String name;
    private String type;
    private Model parent;
    private HashMap<String, Model> children = new HashMap();
    private boolean isCollection;

    public Model(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public Model addChild(String name, String type) {
        Model node = new Model(name, type);
        node.parent = this;
        node.name = name;
        node.type = type;
        this.children.put(name, node);
        return node;
    }

    public void print(PrintStream out) {
        this.printModel(this, 0, out);
    }

    public Model get(String nodeName) {
        Model model = null;
        if (nodeName.contains(".")) {
            if (this.hasChildren()) {
                int idx = nodeName.indexOf(46);
                String parentNodeName = nodeName.substring(0, idx);
                String child = nodeName.substring(idx + 1, nodeName.length());
                Model parentModel = this.children.get(parentNodeName);
                if (parentModel != null) {
                    model = parentModel.get(child);
                }
            }
        } else {
            return this.children.get(nodeName);
        }
        return model;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Model getParent() {
        return this.parent;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public Model setIsCollection(boolean isCollection) {
        this.isCollection = isCollection;
        return this;
    }

    public List<Model> getChildren() {
        return new ArrayList<Model>(this.children.values());
    }

    public List<String> listFields() {
        LinkedList<String> fields = new LinkedList<String>();
        return this.listFields(fields, this.children.values(), "");
    }

    public List<String> listFields(List<String> fieldList, Collection<Model> fields, String prefix) {
        for (Model field : fields) {
            fieldList.add(String.valueOf(prefix) + field.getName());
            this.listFields(fieldList, field.children.values(), String.valueOf(prefix) + field.getName() + ".");
        }
        return fieldList;
    }

    public String toString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.print(new PrintStream(bos, true));
        return bos.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Model)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Model comp = (Model)obj;
        return this.isEqual(this.modelClass, comp.getModelClass()) && this.isEqual(this.name, comp.getName()) && this.isEqual(this.type, comp.type) && this.isEqual(this.children, comp.children);
    }

    public int hashCode() {
        return this.hash(this.modelClass, this.name, this.type, this.children);
    }

    public Class<?> getModelClass() {
        return this.modelClass;
    }

    public void setModelClass(Class<?> modelClass) {
        this.modelClass = modelClass;
    }

    private void printModel(Model node, int depth, PrintStream out) {
        out.println(this.format(node, depth));
        for (Model child : node.children.values()) {
            this.printModel(child, depth + 1, out);
        }
    }

    private String format(Model node, int depth) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < depth) {
            sb.append("  ");
            ++i;
        }
        sb.append(node.children.isEmpty() ? "- " : "* ");
        sb.append(String.valueOf(node.name) + " : " + node.type);
        return sb.toString();
    }

    private boolean isEqual(Object objA, Object objB) {
        if (objA == null && objB == null) {
            return true;
        }
        if (objA == null || objB == null) {
            return false;
        }
        return objA.equals(objB);
    }

    private int hash(Object ... vals) {
        int hash = 7;
        Object[] objectArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Object val = objectArray[n2];
            if (val != null) {
                hash = hash * 37 + val.hashCode();
            }
            ++n2;
        }
        return hash;
    }
}

