/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.core.model;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jboss.tools.fuse.transformation.core.model.Model;

public class ModelBuilder {
    public static Model fromJavaClass(Class<?> javaClass) {
        Model model = new Model(javaClass.getSimpleName(), javaClass.getName());
        LinkedList<Field> fields = new LinkedList<Field>();
        ModelBuilder.getFields(javaClass, fields);
        ModelBuilder.addFieldsToModel(fields, model);
        model.setModelClass(javaClass);
        return model;
    }

    public static Class<?> getFieldType(Field field) {
        Type fieldType;
        if (field.getType().isArray()) {
            return field.getType().getComponentType();
        }
        Class<Object> type = Collection.class.isAssignableFrom(field.getType()) ? ((fieldType = field.getGenericType()) instanceof ParameterizedType ? (Class<Object>)((ParameterizedType)fieldType).getActualTypeArguments()[0] : Object.class) : field.getType();
        return type;
    }

    public static String getListName(Class<?> listType) {
        return "[" + listType.getName() + "]";
    }

    public static String getListType(String listName) {
        return listName.split("\\[")[1].split("\\]")[0];
    }

    private static void addFieldsToModel(List<Field> fields, Model model) {
        for (Field field : fields) {
            Class<Object> fieldClass;
            boolean isCollection = false;
            if (field.getType().isArray()) {
                isCollection = true;
                fieldClass = field.getType().getComponentType();
            } else if (Collection.class.isAssignableFrom(field.getType())) {
                isCollection = true;
                Type ft = field.getGenericType();
                fieldClass = ft instanceof ParameterizedType ? (Class<Object>)((ParameterizedType)ft).getActualTypeArguments()[0] : Object.class;
            } else {
                fieldClass = field.getType();
            }
            String fieldTypeName = isCollection ? ModelBuilder.getListName(fieldClass) : fieldClass.getName();
            Model child = model.addChild(field.getName(), fieldTypeName);
            child.setIsCollection(isCollection);
            if (!ModelBuilder.parseChildren(fieldClass)) continue;
            ModelBuilder.addFieldsToModel(ModelBuilder.getFields(fieldClass, model), child);
        }
    }

    private static List<Field> getFields(Class<?> clazz, Model parent) {
        LinkedList<Field> fields = new LinkedList<Field>();
        boolean cycle = false;
        Model pm = parent;
        while (pm != null) {
            String parentType;
            String string = parentType = pm.isCollection() ? ModelBuilder.getListType(pm.getType()) : pm.getType();
            if (clazz.getName().equals(parentType)) {
                cycle = true;
                break;
            }
            pm = pm.getParent();
        }
        if (!cycle) {
            ModelBuilder.getFields(clazz, fields);
        }
        return fields;
    }

    private static void getFields(Class<?> clazz, List<Field> fields) {
        if (clazz == null || Object.class.equals(clazz)) {
            return;
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!field.isSynthetic()) {
                fields.add(field);
            }
            ++n2;
        }
        ModelBuilder.getFields(clazz.getSuperclass(), fields);
    }

    private static boolean parseChildren(Class<?> fieldClass) {
        boolean excluded = fieldClass.isPrimitive() || String.class.getName().equals(fieldClass.getName()) || fieldClass.getName().startsWith("java.") || Number.class.isAssignableFrom(fieldClass) || fieldClass.isEnum();
        return !excluded;
    }
}

